/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.view.View;
import com.zpj.http.core.IHttp;
import com.zpj.rxlife.LifecycleTransformer;
import com.zpj.rxlife.RxLife;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;

public class HttpObserver<T> {
    private final Observable<T> observable;
    private Disposable disposable;
    private Scheduler subscribeScheduler;
    private Scheduler observeScheduler;
    private final List<LifecycleTransformer<T>> composerList;
    private IHttp.OnSubscribeListener onSubscribeListener;
    private IHttp.OnSuccessListener<T> onSuccessListener;
    private IHttp.OnErrorListener onErrorListener;
    private IHttp.OnCompleteListener onCompleteListener;

    public HttpObserver(ObservableOnSubscribe<T> observableOnSubscribe) {
        this(Observable.create(observableOnSubscribe));
    }

    public HttpObserver(Observable<T> observable) {
        this.observable = observable;
        this.composerList = new ArrayList<LifecycleTransformer<T>>();
    }

    public HttpObserver<T> subscribeOn(Scheduler scheduler) {
        this.subscribeScheduler = scheduler;
        return this;
    }

    public HttpObserver<T> observeOn(Scheduler scheduler) {
        this.observeScheduler = scheduler;
        return this;
    }

    public <R> HttpObserver<R> compose(ObservableTransformer<? super T, ? extends R> composer) {
        return new HttpObserver<T>(this.observable.compose(composer)).subscribeOn(this.subscribeScheduler).observeOn(this.observeScheduler);
    }

    public HttpObserver<T> bindTag(Object tag) {
        return this.bindTag(tag, true);
    }

    public HttpObserver<T> bindTag(Object tag, boolean disposeBefore) {
        this.composerList.add(RxLife.bindTag((Object)tag, (boolean)disposeBefore));
        return this;
    }

    public HttpObserver<T> bindToLife(LifecycleOwner lifecycleOwner) {
        return this.bindToLife(lifecycleOwner, Lifecycle.Event.ON_DESTROY);
    }

    public HttpObserver<T> bindToLife(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
        this.composerList.add(RxLife.bindLifeOwner((LifecycleOwner)lifecycleOwner, (Lifecycle.Event)event));
        return this;
    }

    public HttpObserver<T> bindView(View view) {
        this.composerList.add(RxLife.bindView((View)view));
        return this;
    }

    public HttpObserver<T> bindActivity(Activity activity) {
        this.composerList.add(RxLife.bindActivity((Activity)activity));
        return this;
    }

    public HttpObserver<T> onSubscribe(IHttp.OnSubscribeListener listener) {
        this.onSubscribeListener = listener;
        return this;
    }

    public final HttpObserver<T> onError(IHttp.OnErrorListener listener) {
        this.onErrorListener = listener;
        return this;
    }

    public final HttpObserver<T> onSuccess(IHttp.OnSuccessListener<T> listener) {
        this.onSuccessListener = listener;
        return this;
    }

    public HttpObserver<T> onComplete(IHttp.OnCompleteListener listener) {
        this.onCompleteListener = listener;
        return this;
    }

    public final <R> HttpObserver<R> onNext(final OnNextListener<T, R> listener) {
        Observable o = this.observable.flatMap(new Function<T, ObservableSource<R>>(){

            public ObservableSource<R> apply(@NonNull T t) throws Exception {
                HttpObserver httpObservable;
                if (listener != null && (httpObservable = listener.onNext(t)) != null) {
                    return httpObservable.observable;
                }
                return Observable.empty();
            }
        });
        return this.wrapObservable(new HttpObserver<T>(o));
    }

    public final <R> HttpObserver<R> flatMap(final OnFlatMapListener<T, R> listener) {
        Observable o = this.observable.flatMap(new Function<T, ObservableSource<R>>(){

            public ObservableSource<R> apply(final @NonNull T t) throws Exception {
                return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<R>(){

                    public void subscribe(@NonNull ObservableEmitter<R> emitter) throws Exception {
                        if (listener != null) {
                            listener.onNext(t, emitter);
                        }
                        emitter.onComplete();
                    }
                }).subscribeOn(HttpObserver.this.subscribeScheduler).observeOn(HttpObserver.this.observeScheduler);
            }
        });
        return this.wrapObservable(new HttpObserver<T>(o));
    }

    public Disposable subscribeWithDisposable() {
        if (this.disposable != null) {
            this.cancel();
        }
        this.disposable = this.getObservable().subscribe(new Consumer<T>(){

            public void accept(T t) throws Exception {
                if (HttpObserver.this.onSuccessListener != null) {
                    HttpObserver.this.onSuccessListener.onSuccess(t);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                throwable.printStackTrace();
                if (HttpObserver.this.onErrorListener != null) {
                    HttpObserver.this.onErrorListener.onError(throwable);
                }
            }
        }, new Action(){

            public void run() throws Exception {
                if (HttpObserver.this.onCompleteListener != null) {
                    HttpObserver.this.onCompleteListener.onComplete();
                }
            }
        }, (Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) throws Exception {
                if (HttpObserver.this.onSubscribeListener != null) {
                    HttpObserver.this.onSubscribeListener.onSubscribe(disposable);
                }
            }
        });
        return this.disposable;
    }

    public void subscribe() {
        this.getObservable().subscribe(new Observer<T>(){

            public void onSubscribe(@NonNull Disposable d) {
                if (HttpObserver.this.onSubscribeListener != null) {
                    try {
                        HttpObserver.this.onSubscribeListener.onSubscribe(d);
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }
            }

            public void onNext(@NonNull T data) {
                if (HttpObserver.this.onSuccessListener != null) {
                    try {
                        HttpObserver.this.onSuccessListener.onSuccess(data);
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }
            }

            public void onError(Throwable e) {
                e.printStackTrace();
                if (HttpObserver.this.onErrorListener != null) {
                    HttpObserver.this.onErrorListener.onError(e);
                }
            }

            public void onComplete() {
                if (HttpObserver.this.onCompleteListener != null) {
                    try {
                        HttpObserver.this.onCompleteListener.onComplete();
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }
            }
        });
    }

    private void initScheduler() {
        if (this.subscribeScheduler == null) {
            this.subscribeScheduler = Schedulers.io();
        }
        if (this.observeScheduler == null) {
            this.observeScheduler = AndroidSchedulers.mainThread();
        }
    }

    private Observable<T> getObservable() {
        this.initScheduler();
        Observable o = this.observable;
        for (LifecycleTransformer<T> composer : this.composerList) {
            o = o.compose(composer);
        }
        return o.subscribeOn(this.subscribeScheduler).observeOn(this.observeScheduler);
    }

    private <R> HttpObserver<R> wrapObservable(HttpObserver<R> observer) {
        return observer.subscribeOn(this.subscribeScheduler).observeOn(this.observeScheduler).onSubscribe(this.onSubscribeListener).onError(this.onErrorListener).onComplete(this.onCompleteListener);
    }

    public void cancel() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        this.disposable = null;
    }

    public static interface OnNextListener<T, R> {
        public HttpObserver<R> onNext(T var1) throws Exception;
    }

    public static interface OnFlatMapListener<T, R> {
        public void onNext(T var1, ObservableEmitter<R> var2) throws Exception;
    }
}

