/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.utils;

import com.zpj.http.core.HttpConfig;
import com.zpj.http.core.IHttp;
import com.zpj.http.utils.StringUtil;
import com.zpj.http.utils.Validate;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

public class UrlUtil {
    public static String encodeUrl(String url) {
        try {
            URL u = new URL(url);
            return UrlUtil.encodeUrl(u).toExternalForm();
        }
        catch (Exception e) {
            return url;
        }
    }

    public static URL encodeUrl(URL u) {
        try {
            String urlS = u.toExternalForm();
            urlS = urlS.replaceAll(" ", "%20");
            URI uri = new URI(urlS);
            return new URL(uri.toASCIIString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            return u;
        }
    }

    public static void serialiseRequestUrl(HttpConfig config) throws IOException {
        URL in = config.url();
        StringBuilder url = StringUtil.borrowBuilder();
        boolean first = true;
        url.append(in.getProtocol()).append("://").append(in.getAuthority()).append(in.getPath()).append("?");
        if (in.getQuery() != null) {
            url.append(in.getQuery());
            first = false;
        }
        for (IHttp.KeyVal keyVal : config.data()) {
            Validate.isFalse(keyVal.hasInputStream(), "InputStream data not supported in URL query string.");
            if (!first) {
                url.append('&');
            } else {
                first = false;
            }
            url.append(URLEncoder.encode(keyVal.key(), "UTF-8")).append('=').append(URLEncoder.encode(keyVal.value(), "UTF-8"));
        }
        config.url(new URL(StringUtil.releaseBuilder(url)));
        config.data().clear();
    }
}

