/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import com.zpj.http.core.HttpObserver;
import com.zpj.http.parser.html.nodes.Document;
import io.reactivex.disposables.Disposable;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public interface IHttp {

    public static interface KeyVal {
        public KeyVal key(String var1);

        public String key();

        public KeyVal value(String var1);

        public String value();

        public KeyVal inputStream(InputStream var1);

        public InputStream inputStream();

        public boolean hasInputStream();

        public KeyVal contentType(String var1);

        public String contentType();

        public KeyVal setListener(OnStreamWriteListener var1);

        public OnStreamWriteListener getListener();
    }

    public static interface Response {
        public Response execute() throws Exception;

        public boolean hasHeader(String var1);

        public boolean hasHeaderWithValue(String var1, String var2);

        public String header(String var1);

        public Method method();

        public int statusCode();

        public String statusMessage();

        public String charset();

        public String contentType();

        public long contentLength();

        public String body();

        public byte[] bodyAsBytes();

        public Response bufferUp();

        public BufferedInputStream bodyStream();

        public void close();

        public void disconnect();

        public void closeIO();
    }

    public static interface Request {
        public Response response() throws Exception;

        public Response syncExecute() throws Exception;

        public String syncToStr() throws Exception;

        public Document syncToHtml() throws Exception;

        public JSONObject syncToJsonObject() throws Exception;

        public JSONArray syncToJsonArray() throws Exception;

        public Document syncToXml() throws Exception;

        public HttpObserver<Response> execute();

        public HttpObserver<String> toStr();

        public HttpObserver<Document> toHtml();

        public HttpObserver<JSONObject> toJsonObject();

        public HttpObserver<JSONArray> toJsonArray();

        public HttpObserver<Document> toXml();
    }

    public static interface OnStreamWriteListener {
        public void onBytesWritten(int var1);

        public boolean shouldContinue();
    }

    public static interface OnSubscribeListener {
        public void onSubscribe(Disposable var1) throws Exception;
    }

    public static interface OnCompleteListener {
        public void onComplete() throws Exception;
    }

    public static interface OnSuccessListener<T> {
        public void onSuccess(T var1) throws Exception;
    }

    public static interface OnErrorListener {
        public void onError(Throwable var1);
    }

    public static interface OnRedirectListener {
        public boolean onRedirect(int var1, String var2);
    }

    public static enum Method {
        GET(false),
        POST(true),
        PUT(true),
        DELETE(false),
        PATCH(true),
        HEAD(false),
        OPTIONS(false),
        TRACE(false);

        private final boolean hasBody;

        private Method(boolean hasBody) {
            this.hasBody = hasBody;
        }

        public final boolean hasBody() {
            return this.hasBody;
        }
    }
}

