/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.load_wrapper;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshContentView;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.error.OnErrorRefreshClickListener;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import java.util.List;

public class LoadWrapperLayout
extends FrameLayout
implements ErrorRefreshContentView,
OnErrorRefreshClickListener {
    private List<Integer> componentIds = ListUtils.newArrayList(R.id.ch_rootLoadWrapper, R.id.ch_progressLoadWrapperDefault, R.id.ch_errorLoadWrapperDefault, R.id.ch_layoutLoadWrapperProgress, R.id.ch_layoutLoadWrapperError, R.id.ch_layoutLoadWrapperContent);
    @Nullable
    private LayoutInflater inflater;
    private CircularProgressView progressLoadWrapper;
    private ErrorRefreshView errorLoadWrapper;
    private FrameLayout layoutLoadWrapperProgress;
    private FrameLayout layoutLoadWrapperError;
    private FrameLayout layoutLoadWrapperContent;
    @Nullable
    private View progressView;
    @Nullable
    private View errorView;
    @Nullable
    private OnErrorRefreshClickListener listener;

    public LoadWrapperLayout(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.inflater = LayoutInflater.from((Context)context);
        this.inflater.inflate(R.layout.ch_plugin_layout_load_wrapper, (ViewGroup)this);
        this.progressLoadWrapper = (CircularProgressView)this.findViewById(R.id.ch_progressLoadWrapperDefault);
        this.errorLoadWrapper = (ErrorRefreshView)this.findViewById(R.id.ch_errorLoadWrapperDefault);
        this.errorLoadWrapper.setOnErrorRefreshClickListener(this);
        this.layoutLoadWrapperProgress = (FrameLayout)this.findViewById(R.id.ch_layoutLoadWrapperProgress);
        this.layoutLoadWrapperError = (FrameLayout)this.findViewById(R.id.ch_layoutLoadWrapperError);
        this.layoutLoadWrapperContent = (FrameLayout)this.findViewById(R.id.ch_layoutLoadWrapperContent);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LoadWrapperLayout, 0, 0);
            try {
                this.setProgressView(typedArray.getResourceId(R.styleable.LoadWrapperLayout_ch_progressView, 0));
                this.setErrorView(typedArray.getResourceId(R.styleable.LoadWrapperLayout_ch_errorView, 0));
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setLoadState(FetchState fetchState) {
        this.setWrapperVisibility(fetchState == FetchState.LOADING, this.progressView, this.progressLoadWrapper, (View)this.layoutLoadWrapperProgress);
        this.setWrapperVisibility(fetchState == FetchState.FAILED, this.errorView, (View)this.errorLoadWrapper, (View)this.layoutLoadWrapperError);
        Views.setVisibility((View)this.layoutLoadWrapperContent, fetchState == FetchState.COMPLETE);
    }

    private void setWrapperVisibility(boolean visible, @Nullable View conditionView, View defaultView, View wrapper) {
        if (conditionView == null) {
            Views.setVisibility(defaultView, visible);
        } else {
            Views.setVisibility(wrapper, visible);
        }
    }

    @Override
    public void setOnErrorRefreshClickListener(@Nullable OnErrorRefreshClickListener listener) {
        this.listener = listener;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child != null && this.componentIds.contains(child.getId())) {
            super.addView(child, index, params);
        } else if (this.layoutLoadWrapperContent != null && child != null) {
            this.layoutLoadWrapperContent.addView(child, index, params);
        }
    }

    private void setProgressView(@LayoutRes int id2) {
        if (id2 != 0 && this.inflater != null) {
            this.progressView = this.inflater.inflate(id2, null);
            this.layoutLoadWrapperProgress.removeAllViews();
            if (this.progressView != null) {
                this.layoutLoadWrapperProgress.addView(this.progressView);
            }
        }
    }

    private void setErrorView(@LayoutRes int id2) {
        if (id2 != 0 && this.inflater != null) {
            View errorView = this.inflater.inflate(id2, null);
            if (errorView instanceof ErrorRefreshContentView) {
                ((ErrorRefreshContentView)errorView).setOnErrorRefreshClickListener(this);
            }
            this.layoutLoadWrapperError.removeAllViews();
            if (errorView != null) {
                this.layoutLoadWrapperError.addView(errorView);
            }
            this.errorView = errorView;
        }
    }

    @Nullable
    public View getErrorView() {
        return this.errorView;
    }

    @Override
    public void onRefreshClick() {
        if (this.listener != null) {
            this.listener.onRefreshClick();
        }
    }
}

