/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.Instagram;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dock.DockLayout;
import com.zoyi.channel.plugin.android.view.integrations.instagram.InstagramMediaAdapter;
import com.zoyi.channel.plugin.android.view.integrations.instagram.InstagramPreviewItemView;
import com.zoyi.channel.plugin.android.view.integrations.instagram.OnInstagramThumbnailClickListener;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import com.zoyi.com.annimon.stream.Stream;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class InstagramView
extends FrameLayout
implements OnInstagramThumbnailClickListener {
    private HorizontalScrollView scrollInstagramDock;
    private DockLayout dockLayout;
    private PhotoViewPager viewPager;
    private InstagramMediaAdapter adapter;
    private TextView textUsername;
    private View viewPage;
    private TextView textPage;
    private View buttonVolume;
    private ImageView iconVolume;
    private AppCompatTextView textLike;
    private AppCompatTextView textComment;
    private boolean isVolumeOn = false;
    private List<String> dataTypes = Collections.emptyList();
    private int totalPages = 0;
    @Nullable
    private String permalink;

    public InstagramView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public InstagramView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public InstagramView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_integration_instagram, (ViewGroup)this);
        this.scrollInstagramDock = (HorizontalScrollView)this.findViewById(R.id.ch_scrollInstagramDock);
        this.dockLayout = (DockLayout)this.findViewById(R.id.ch_dockInstagram);
        this.adapter = new InstagramMediaAdapter(context);
        this.viewPager = (PhotoViewPager)this.findViewById(R.id.ch_viewPagerInstagram);
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                InstagramView.this.onPageChanged(position);
            }
        });
        this.textUsername = (TextView)this.findViewById(R.id.ch_textInstagramUsername);
        this.viewPage = this.findViewById(R.id.ch_viewInstagramPage);
        this.textPage = (TextView)this.findViewById(R.id.ch_textInstagramPage);
        this.iconVolume = (ImageView)this.findViewById(R.id.ch_iconInstagramVolume);
        this.buttonVolume = this.findViewById(R.id.ch_viewInstagramVolume);
        this.buttonVolume.setOnClickListener(v -> {
            boolean bl = this.isVolumeOn = !this.isVolumeOn;
            if (this.iconVolume != null) {
                this.iconVolume.setImageResource(this.isVolumeOn ? R.drawable.ch_volume_up_filled_16 : R.drawable.ch_volume_off_filled_16);
            }
            if (this.adapter != null) {
                this.adapter.changeVideoVolumeState(this.isVolumeOn);
            }
        });
        this.textLike = (AppCompatTextView)this.findViewById(R.id.ch_textInstagramLike);
        this.textComment = (AppCompatTextView)this.findViewById(R.id.ch_textInstagramComment);
        this.findViewById(R.id.ch_layoutInstagramUsername).setOnClickListener(v -> Executor.openExternalBrowser(this.getContext(), this.permalink));
        this.findViewById(R.id.ch_layoutInstagramAction).setOnClickListener(v -> Executor.openExternalBrowser(this.getContext(), this.permalink));
        this.findViewById(R.id.ch_buttonSeeMoreInstagram).setOnClickListener(v -> Executor.openExternalBrowser(this.getContext(), this.permalink));
    }

    public void setInstagram(Instagram instagram) {
        if (!instagram.getData().isEmpty()) {
            this.setData(instagram.getData().get(0));
        }
        this.dockLayout.removeAllViews();
        if (instagram.getData().size() > 1) {
            this.scrollInstagramDock.setVisibility(0);
            for (InstagramData data : instagram.getData()) {
                this.dockLayout.addView((View)new InstagramPreviewItemView(this.getContext(), data, this));
            }
        } else {
            this.scrollInstagramDock.setVisibility(8);
        }
        this.setBorder(0);
    }

    private void setData(InstagramData data) {
        this.dataTypes = Stream.ofNullable(data.getData()).map(InstagramMediaEntity::getMediaType).toList();
        this.totalPages = data.getData().size();
        this.permalink = data.getPermalink();
        this.adapter.setItems(data);
        this.textUsername.setText((CharSequence)data.getUsername());
        Views.setVisibility(this.viewPage, data.getData().size() > 1);
        this.textLike.setText((CharSequence)NumberFormat.getInstance(Locale.US).format(data.getLikeCount()));
        this.textComment.setText((CharSequence)NumberFormat.getInstance(Locale.US).format(data.getCommentsCount()));
        this.onPageChanged(0);
        this.viewPager.post(() -> this.viewPager.setCurrentItem(0));
    }

    @Override
    public void onDataClick(InstagramData data, int position) {
        this.setBorder(position);
        this.setData(data);
    }

    private void setBorder(int position) {
        if (this.dockLayout != null) {
            for (int i = 0; i < this.dockLayout.getChildCount(); ++i) {
                View child = this.dockLayout.getChildAt(i);
                if (!(child instanceof InstagramPreviewItemView)) continue;
                ((InstagramPreviewItemView)child).setBorder(i == position);
            }
        }
    }

    private void onPageChanged(int currentPage) {
        this.textPage.setText((CharSequence)String.format(Locale.US, "%d/%d", currentPage + 1, this.totalPages));
        Views.setVisibility(this.buttonVolume, currentPage < this.dataTypes.size() && "VIDEO".equals(this.dataTypes.get(currentPage)));
        if (this.adapter != null) {
            this.adapter.onPageChanged(currentPage);
        }
    }

    public void onResume() {
        if (this.adapter != null) {
            this.adapter.onResume();
        }
    }

    public void onPause() {
        if (this.adapter != null) {
            this.adapter.onPause();
        }
    }

    public void clear() {
        if (this.adapter != null) {
            this.adapter.clear();
        }
    }
}

