/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.dialog.bottom_sheet;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.BaseBottomSheetDialog;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.icon_button.IconButtonView;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.listener.OnIconButtonClickListener;
import java.util.ArrayList;

public class IconButtonBottomSheetDialog
extends BaseBottomSheetDialog {
    private ArrayList<IconButtonView> buttons = new ArrayList();

    public IconButtonBottomSheetDialog(@NonNull Context context) {
        super(context);
        this.paddingTop = 6;
        this.paddingBottom = 6;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setOrientation(1);
        this.setDialogView();
    }

    private void setDialogView() {
        for (IconButtonView iconButton : this.buttons) {
            if (iconButton == null) continue;
            this.addContentView((View)iconButton);
        }
    }

    public IconButtonBottomSheetDialog addButton(@DrawableRes int iconDrawableId, String messageText, OnIconButtonClickListener listener) {
        this.buttons.add(this.createButton(iconDrawableId, messageText, R.color.ch_grey700, R.color.ch_grey900, listener));
        return this;
    }

    public IconButtonBottomSheetDialog addButton(@DrawableRes int iconDrawableId, String messageText, int iconColorId, int textColorId, OnIconButtonClickListener listener) {
        this.buttons.add(this.createButton(iconDrawableId, messageText, iconColorId, textColorId, listener));
        return this;
    }

    private IconButtonView createButton(@DrawableRes int iconDrawable, String messageText, int iconColorId, int textColorId, OnIconButtonClickListener listener) {
        IconButtonView iconButton = new IconButtonView(this.getContext());
        iconButton.setData(iconDrawable, messageText, iconColorId, textColorId);
        iconButton.setOnClickListener(v -> {
            if (listener != null) {
                listener.onButtonClick();
            }
            if (this.isShowing()) {
                this.dismiss();
            }
        });
        return iconButton;
    }

    public ArrayList<IconButtonView> getButtons() {
        return this.buttons;
    }
}

