/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class ApiCaller<E>
extends Binder {
    private Observable<E> observable;
    @Nullable
    private Subscription subscription;
    @Nullable
    private ErrorFunction onErrorFunc;
    @Nullable
    private CompleteFunction onBeforeCompleteFunc;
    @Nullable
    private CompleteFunction onCompleteFunc;
    @Nullable
    private SuccessFunction<E> callFunc;

    public ApiCaller(Observable<E> observable) {
        this.observable = observable;
    }

    public ApiCaller<E> delay(long milliseconds) {
        this.observable = this.observable.delay(milliseconds, TimeUnit.MILLISECONDS);
        return this;
    }

    public ApiCaller<E> onError(ErrorFunction onErrorFunc) {
        this.onErrorFunc = onErrorFunc;
        return this;
    }

    public ApiCaller<E> onBeforeComplete(CompleteFunction onBeforeCompleteFunc) {
        this.onBeforeCompleteFunc = onBeforeCompleteFunc;
        return this;
    }

    public ApiCaller<E> onComplete(CompleteFunction onCompleteFunc) {
        this.onCompleteFunc = onCompleteFunc;
        return this;
    }

    public ApiCaller<E> call(SuccessFunction<E> callFunc) {
        this.callFunc = callFunc;
        return this.call();
    }

    public ApiCaller<E> call() {
        this.subscription = this.observable.onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<E>(){

            @Override
            public void onError(RetrofitException error) {
                if (ApiCaller.this.onBeforeCompleteFunc != null) {
                    ApiCaller.this.onBeforeCompleteFunc.call();
                }
                if (ApiCaller.this.onErrorFunc != null) {
                    ApiCaller.this.onErrorFunc.call(error);
                }
                if (ApiCaller.this.onCompleteFunc != null) {
                    ApiCaller.this.onCompleteFunc.call();
                }
            }

            @Override
            public void onSuccess(@NonNull E e) {
                if (ApiCaller.this.onBeforeCompleteFunc != null) {
                    ApiCaller.this.onBeforeCompleteFunc.call();
                }
                if (ApiCaller.this.callFunc != null) {
                    ApiCaller.this.callFunc.call(e);
                }
                if (ApiCaller.this.onCompleteFunc != null) {
                    ApiCaller.this.onCompleteFunc.call();
                }
            }

            @Override
            public void onSuccessWithNull() {
                if (ApiCaller.this.onBeforeCompleteFunc != null) {
                    ApiCaller.this.onBeforeCompleteFunc.call();
                }
                if (ApiCaller.this.onCompleteFunc != null) {
                    ApiCaller.this.onCompleteFunc.call();
                }
            }
        });
        return this;
    }

    @Override
    protected boolean isRunning() {
        return this.subscription != null && !this.subscription.isUnsubscribed();
    }

    @Override
    public void unbind() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    public static interface SuccessFunction<T> {
        public void call(T var1);
    }

    public static interface ErrorFunction {
        public void call(RetrofitException var1);
    }

    public static interface CompleteFunction {
        public void call();
    }
}

