/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.LoungeAppButtonView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.util.ResUtils;
import java.util.List;

public class LoungeIntegrationView
extends ViewGroup {
    private Context context;
    private int buttonSize;
    private int spacing;
    @Nullable
    private OnIntegrationClickListener listener;

    public LoungeIntegrationView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public LoungeIntegrationView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoungeIntegrationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.buttonSize = ResUtils.getDimen(context, R.dimen.ch_app_messenger_button_size);
        this.spacing = ResUtils.getDimen(context, R.dimen.ch_lounge_integration_button_space);
    }

    public void setListener(@Nullable OnIntegrationClickListener listener) {
        this.listener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        if (count == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int availableWidth = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int maxColumnCount = Math.max(1, (availableWidth + this.spacing) / (this.buttonSize + this.spacing));
        int maxRowCount = count / maxColumnCount + (count % maxColumnCount > 0 ? 1 : 0);
        int height = maxRowCount * this.buttonSize + Math.max(0, maxRowCount - 1) * this.spacing + this.getPaddingTop() + this.getPaddingBottom();
        int childMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.buttonSize, (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(childMeasureSpec, childMeasureSpec);
        }
        this.setMeasuredDimension(availableWidth + this.getPaddingLeft() + this.getPaddingRight(), height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int availableWidth = r - l - this.getPaddingLeft() - this.getPaddingRight();
        if (count > 0) {
            int maxColumnCount = Math.max(1, (availableWidth + this.spacing) / (this.buttonSize + this.spacing));
            int maxRowCount = count / maxColumnCount + (count % maxColumnCount > 0 ? 1 : 0);
            int baseColumnCount = count / maxRowCount;
            int restCount = count % maxRowCount;
            int viewCount = 0;
            for (int i = 1; i <= maxRowCount; ++i) {
                int columnCount = baseColumnCount + (restCount >= i ? 1 : 0);
                int startX = (availableWidth - columnCount * this.buttonSize - (columnCount - 1) * this.spacing) / 2 + this.getPaddingLeft();
                int startY = (i - 1) * (this.buttonSize + this.spacing) + this.getPaddingTop();
                for (int j = 0; j < columnCount; ++j) {
                    View child = this.getChildAt(j + viewCount);
                    child.layout(startX + j * (this.buttonSize + this.spacing), startY, startX + j * (this.buttonSize + this.spacing) + this.buttonSize, startY + this.buttonSize);
                }
                viewCount += columnCount;
            }
        }
    }

    public void setAppMessengers(List<Contact> contacts) {
        this.removeAllViews();
        for (Contact contact : contacts) {
            this.addView((View)new LoungeAppButtonView(this.context, contact, this.listener));
        }
    }
}

