/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.com.bumptech.glide.Glide;

public class LoungeIntegrationSingleView
extends FrameLayout {
    private View root;
    private ImageView imageIcon;
    private TextView textTitle;
    private TextView textDescription;
    @Nullable
    private OnIntegrationClickListener listener;

    public LoungeIntegrationSingleView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public LoungeIntegrationSingleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoungeIntegrationSingleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void setListener(@Nullable OnIntegrationClickListener listener) {
        this.listener = listener;
    }

    @Initializer
    private void init(Context context) {
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_lounge_integration_single, (ViewGroup)this);
        this.imageIcon = (ImageView)this.root.findViewById(R.id.ch_imageIntegrationSingleIcon);
        this.textTitle = (TextView)this.root.findViewById(R.id.ch_textIntegrationSingleTitle);
        this.textDescription = (TextView)this.root.findViewById(R.id.ch_textIntegrationSingleDescription);
    }

    public void setAppMessenger(@NonNull Contact contact) {
        contact.setIcon(this.imageIcon);
        Views.setVisibility((View)this.textTitle, contact.getTitle() != null);
        this.textTitle.setText((CharSequence)contact.getTitle());
        Views.setVisibility((View)this.textDescription, contact.getDescription() != null);
        this.textDescription.setText((CharSequence)contact.getDescription());
        this.root.setOnClickListener(v -> contact.doAction(this.listener));
    }

    protected void onDetachedFromWindow() {
        Glide.clear((View)this.imageIcon);
        super.onDetachedFromWindow();
    }
}

