/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsActivity;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.ChannelWatermarkView;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeAdapter;
import com.zoyi.channel.plugin.android.activity.lounge.LoungePresenter;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.LoungeIntegrationSingleView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.LoungeIntegrationView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.model.LinkContact;
import com.zoyi.channel.plugin.android.activity.lounge.view.lounge_media.LoungeMediaErrorCardView;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.model.entity.LoungeMedia;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.Instagram;
import com.zoyi.channel.plugin.android.selector.AppMessengerSelector;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ChatsSelector;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.coordinator.LoungeCoordinatorLayout;
import com.zoyi.channel.plugin.android.view.coordinator.PaddingNestedScrollView;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.integrations.instagram.InstagramView;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.load_wrapper.LoadWrapperLayout;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;
import com.zoyi.channel.plugin.android.view.viewgroup.MaxWidthLinearLayout;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import java.util.List;

public class LoungeActivity
extends BaseActivity2
implements LoungeContract.View,
OnChatClickListener,
LoungeHeaderInteractionListener,
OnIntegrationClickListener {
    private LoungeCoordinatorLayout layoutCoordinator;
    private LoungeHeaderView headerLounge;
    private View buttonCloseLounge;
    private LoadWrapperLayout loadWrapperLayout;
    private View layoutPreviewHeader;
    private View layoutPreviewChat;
    private RecyclerView recyclerViewChat;
    private View buttonChatStartChats;
    private TextView textLoungePreviewChatStartChats;
    private ImageView chatStartButton;
    private ChatStartButton buttonChatStartWelcome;
    private FrameLayout layoutLoungeSeeMoreChats;
    private CardView cardLoungeSeeMoreChats;
    private TextView textLoungeSeeMoreChats;
    private View layoutPreviewWelcome;
    private AvatarLayout avatarWelcomeMessageProfile;
    private TextView textWelcomeMessageProfile;
    private EllipsizeTextView textWelcomeMessage;
    private CardView cardAppMessengers;
    private LoungeIntegrationSingleView viewSingleAppMessenger;
    private LoungeIntegrationView viewAppMessengers;
    private LoadWrapperLayout loadWrapperInstagram;
    private InstagramView viewInstagram;
    private PaddingNestedScrollView scrollViewLounge;
    private MaxWidthLinearLayout maxWidthLounge;
    private ChannelWatermarkView watermark;
    private View dummyWatermark;
    private LoungeAdapter adapter;
    private LoungeContract.Presenter presenter;
    private LinearLayoutManager layoutManager;
    @Nullable
    private Binder appMessengersBinder;
    @Nullable
    private Binder moreChatBinder;
    @Nullable
    private Binder startChatBinder;
    @Nullable
    private Binder channelBinder;
    private boolean canStartChat = true;
    @Nullable
    private String contentId = null;
    @Nullable
    private String presetMessage = null;
    private boolean handleOpenChat = false;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_lounge);
        this.setOutTransition(Transition.SLIDE_FROM_BOTTOM);
        this.layoutCoordinator = (LoungeCoordinatorLayout)this.findViewById(R.id.ch_layoutLoungeCoordinator);
        this.headerLounge = (LoungeHeaderView)this.findViewById(R.id.ch_viewLoungeHeader);
        this.headerLounge.setLoungeHeaderInteractionListener(this);
        this.buttonCloseLounge = this.findViewById(R.id.ch_buttonLoungeCloseOverlay);
        this.buttonCloseLounge.setOnClickListener(v -> Action.invoke(ActionType.EXIT));
        this.loadWrapperLayout = (LoadWrapperLayout)this.findViewById(R.id.ch_loadWrapperLounge);
        this.loadWrapperLayout.setOnErrorRefreshClickListener(() -> this.presenter.fetchPreviewData());
        this.layoutPreviewHeader = this.findViewById(R.id.ch_viewLoungePreviewHeader);
        this.layoutPreviewChat = this.findViewById(R.id.ch_layoutLoungePreviewChat);
        this.layoutPreviewWelcome = this.findViewById(R.id.ch_layoutLoungePreviewWelcomeMessage);
        this.layoutPreviewWelcome.setOnClickListener(v -> this.startChat(Transition.SLIDE_FROM_RIGHT));
        this.avatarWelcomeMessageProfile = (AvatarLayout)this.findViewById(R.id.ch_avatarLoungePreviewWelcomeMessage);
        this.textWelcomeMessageProfile = (TextView)this.findViewById(R.id.ch_textLoungePreviewWelcomeMessageName);
        this.textWelcomeMessage = (EllipsizeTextView)this.findViewById(R.id.ch_textLoungePreviewWelcomeMessageMessage);
        this.cardAppMessengers = (CardView)this.findViewById(R.id.ch_cardLoungeIntegrations);
        this.viewAppMessengers = (LoungeIntegrationView)this.findViewById(R.id.ch_viewLoungeIntegrations);
        this.viewAppMessengers.setListener(this);
        this.viewSingleAppMessenger = (LoungeIntegrationSingleView)this.findViewById(R.id.ch_viewLoungeSingleIntegration);
        this.viewSingleAppMessenger.setListener(this);
        this.watermark = (ChannelWatermarkView)this.findViewById(R.id.ch_viewLoungeWatermark);
        this.maxWidthLounge = (MaxWidthLinearLayout)this.findViewById(R.id.ch_layoutMaxWidthLoungeLinear);
        this.scrollViewLounge = (PaddingNestedScrollView)this.findViewById(R.id.ch_scrollViewLounge);
        this.dummyWatermark = this.findViewById(R.id.ch_viewLoungeDummyWatermark);
        this.scrollViewLounge.setListener(scrollPosition -> this.setWatermarkAlphaAnimation(scrollPosition));
        this.maxWidthLounge.getViewTreeObserver().addOnGlobalLayoutListener(() -> this.setWatermarkAlphaAnimation(this.scrollViewLounge.getScrollY()));
        this.appMessengersBinder = AppMessengerSelector.bindIntegrations((Context)this, (Action1<List<Contact>>)((Action1)contacts -> {
            if (contacts.size() == 1 && !(contacts.get(0) instanceof LinkContact)) {
                this.viewSingleAppMessenger.setVisibility(0);
                this.viewSingleAppMessenger.setAppMessenger((Contact)contacts.get(0));
                this.viewAppMessengers.setVisibility(8);
            } else if (contacts.size() > 1) {
                this.viewAppMessengers.setVisibility(0);
                this.viewAppMessengers.setAppMessengers((List<Contact>)contacts);
                this.viewSingleAppMessenger.setVisibility(8);
            } else {
                this.viewSingleAppMessenger.setVisibility(8);
                this.viewAppMessengers.setVisibility(8);
            }
        }));
        this.layoutCoordinator.setOnNestedScrollChangeListener((scrollPosition, headerHeight) -> {
            float maxScrollPosition = Math.min(scrollPosition, headerHeight);
            float closeButtonAlpha = maxScrollPosition / (float)headerHeight;
            this.headerLounge.setAlpha(1.0f - closeButtonAlpha);
            this.buttonCloseLounge.setAlpha(closeButtonAlpha);
            this.buttonCloseLounge.setVisibility(scrollPosition == 0 ? 8 : 0);
        });
        this.adapter = new LoungeAdapter();
        this.adapter.setListener(this);
        this.buttonChatStartChats = this.findViewById(R.id.ch_buttonLoungePreviewChatStartChats);
        this.buttonChatStartChats.setOnClickListener(v -> {
            if (this.canStartChat) {
                this.startChat(Transition.SLIDE_FROM_RIGHT);
            }
        });
        this.chatStartButton = (ImageView)this.findViewById(R.id.ch_imageLoungePreviewChatStartButton);
        this.textLoungePreviewChatStartChats = (TextView)this.findViewById(R.id.ch_textLoungePreviewChatStartChats);
        this.startChatBinder = ChannelSelector.bindDisableStartChat((Action1<Boolean>)((Action1)disabled -> {
            this.canStartChat = disabled == false;
            this.chatStartButton.setColorFilter(ResUtils.getColor(disabled != false ? R.color.ch_grey500 : R.color.ch_grey900));
            this.textLoungePreviewChatStartChats.setTextColor(ResUtils.getColor(disabled != false ? R.color.ch_grey500 : R.color.ch_grey900));
        }));
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.recyclerViewChat = (RecyclerView)this.findViewById(R.id.ch_recyclerViewLoungePreviewChat);
        this.recyclerViewChat.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerViewChat.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerViewChat.setItemAnimator(null);
        this.recyclerViewChat.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.loadWrapperInstagram = (LoadWrapperLayout)this.findViewById(R.id.ch_loadWrapperLoungeMediaInstagram);
        this.viewInstagram = (InstagramView)this.findViewById(R.id.ch_viewLoungeInstagram);
        this.loadWrapperInstagram.setOnErrorRefreshClickListener(() -> this.presenter.fetchLoungeMediaData("instagram"));
        this.setLoungeMediaErrorViewDescription(this.loadWrapperInstagram.getErrorView(), "instagram");
        this.buttonChatStartWelcome = (ChatStartButton)this.findViewById(R.id.ch_buttonLoungePreviewChatStartWelcome);
        this.buttonChatStartWelcome.setOnClickListener(v -> this.startChat(Transition.SLIDE_FROM_RIGHT));
        this.layoutLoungeSeeMoreChats = (FrameLayout)this.findViewById(R.id.ch_layoutLoungeSeeMoreChats);
        this.cardLoungeSeeMoreChats = (CardView)this.findViewById(R.id.ch_cardLoungeSeeMoreChats);
        this.cardLoungeSeeMoreChats.setOnClickListener(v -> this.showChats());
        this.textLoungeSeeMoreChats = (TextView)this.findViewById(R.id.ch_textLoungeSeeMoreChats);
        this.moreChatBinder = ChatsSelector.bindUserChatsMore((Action2<Boolean, Integer>)((Action2)(hasNext, invisibleCount) -> {
            if (invisibleCount > 0) {
                this.cardLoungeSeeMoreChats.setVisibility(0);
                this.textLoungeSeeMoreChats.setText((CharSequence)String.format(ResUtils.getString(hasNext != false ? "ch.lounge.show_previous_chats_more" : "ch.lounge.show_previous_chats"), invisibleCount));
            } else {
                this.cardLoungeSeeMoreChats.setVisibility(8);
            }
        }));
        this.presenter = new LoungePresenter(this, this.adapter, this.adapter, this.getString("topActivityName"));
        this.bindPresenter(this.presenter);
        GlobalStore.get().messengerState.set(true);
        PopupStore.get().popupMessage.set(null);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.contentId = intent.getStringExtra("chatContentId");
            this.presetMessage = intent.getStringExtra("chatPresetMessage");
            this.handleOpenChat = intent.getBooleanExtra("handleOpenChat", false);
        }
        return true;
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent != null) {
            this.contentId = intent.getStringExtra("chatContentId");
            this.presetMessage = intent.getStringExtra("chatPresetMessage");
            this.handleOpenChat = intent.getBooleanExtra("handleOpenChat", false);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (this.viewInstagram != null) {
            this.viewInstagram.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.viewInstagram != null) {
            this.viewInstagram.onPause();
        }
        if (this.isFinishing()) {
            GlobalStore.get().messengerState.set(false);
            Action.invoke(ActionType.MESSENGER_CLOSED);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.viewInstagram != null) {
            this.viewInstagram.clear();
        }
        if (this.appMessengersBinder != null) {
            this.appMessengersBinder.unbind();
            this.appMessengersBinder = null;
        }
        if (this.moreChatBinder != null) {
            this.moreChatBinder.unbind();
            this.moreChatBinder = null;
        }
        if (this.startChatBinder != null) {
            this.startChatBinder.unbind();
            this.startChatBinder = null;
        }
        if (this.channelBinder != null) {
            this.channelBinder.unbind();
            this.channelBinder = null;
        }
    }

    @Override
    public void onPreviewStateChange(PreviewState previewState) {
        this.layoutPreviewChat.setVisibility(8);
        this.layoutPreviewHeader.setVisibility(8);
        this.layoutPreviewWelcome.setVisibility(8);
        this.buttonChatStartWelcome.setVisibility(8);
        this.layoutLoungeSeeMoreChats.setVisibility(8);
        this.cardAppMessengers.setVisibility(8);
        switch (previewState) {
            case CHATS: {
                this.loadWrapperLayout.setLoadState(FetchState.COMPLETE);
                this.layoutPreviewHeader.setVisibility(0);
                this.layoutPreviewChat.setVisibility(0);
                this.layoutLoungeSeeMoreChats.setVisibility(0);
                this.cardAppMessengers.setVisibility(0);
                break;
            }
            case WELCOME: {
                this.loadWrapperLayout.setLoadState(FetchState.COMPLETE);
                this.layoutPreviewWelcome.setVisibility(0);
                this.buttonChatStartWelcome.setVisibility(0);
                this.layoutLoungeSeeMoreChats.setVisibility(0);
                this.cardAppMessengers.setVisibility(0);
                break;
            }
            case LOADING: {
                this.loadWrapperLayout.setLoadState(FetchState.LOADING);
                break;
            }
            case FAILED: {
                this.loadWrapperLayout.setLoadState(FetchState.FAILED);
            }
        }
        if ((previewState == PreviewState.WELCOME || previewState == PreviewState.CHATS) && this.handleOpenChat) {
            if (this.contentId != null) {
                this.startChat(ChatContentType.USER_CHAT, this.contentId, Transition.NONE);
            } else if (this.presetMessage != null) {
                this.startChat(this.presetMessage, Transition.NONE);
            } else {
                this.startChat(Transition.NONE);
            }
            this.contentId = null;
            this.presetMessage = null;
            this.handleOpenChat = false;
        }
    }

    @Override
    public void onLoungeMediaStateChange(String type, FetchState fetchState) {
        switch (fetchState) {
            case COMPLETE: 
            case FAILED: 
            case LOADING: {
                if (!"instagram".equals(type)) break;
                this.loadWrapperInstagram.setVisibility(0);
                this.loadWrapperInstagram.setLoadState(fetchState);
                break;
            }
            case EMPTY: {
                if (!"instagram".equals(type)) break;
                this.loadWrapperInstagram.setVisibility(8);
            }
        }
    }

    @Override
    public void onFetchLoungeMediaInstagram(List<LoungeMedia> loungeMedia) {
        for (LoungeMedia media : loungeMedia) {
            if (!(media instanceof Instagram)) continue;
            if (!((Instagram)media).getData().isEmpty()) {
                this.viewInstagram.setVisibility(0);
                this.viewInstagram.setInstagram((Instagram)media);
                continue;
            }
            this.viewInstagram.setVisibility(8);
        }
    }

    @Override
    public void handleWatermarkVisibility() {
        Channel channel = ChannelStore.get().channelState.get();
        if (channel != null && channel.isWhiteLabelFeature()) {
            this.deactivateWatermark();
        } else {
            this.activateWatermark();
        }
    }

    @Override
    public void deactivateWatermark() {
        this.watermark.setActivateState(false);
        this.dummyWatermark.setVisibility(8);
    }

    @Override
    public void onDefaultProfileChange(ProfileEntity profileEntity) {
        if (profileEntity != null) {
            this.avatarWelcomeMessageProfile.set(profileEntity);
            this.textWelcomeMessageProfile.setText((CharSequence)profileEntity.getName());
        }
    }

    @Override
    public void onWelcomeMessageChange(String plainText) {
        if (plainText != null) {
            this.textWelcomeMessage.setText(plainText);
        }
    }

    @Override
    public void onChatItemClick(@NonNull ChatItem chatItem) {
        this.startChat(chatItem.getType(), chatItem.getSubKey(), Transition.SLIDE_FROM_RIGHT);
    }

    @Override
    public void onChatItemLongClick(@NonNull ChatItem chatItem) {
        ((ChannelDialog)((Object)((ChannelDialog)((Object)((ChannelDialog)((Object)new ChannelDialog((Context)this).setDescription(ResUtils.getString("ch.chat.delete_description")).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, v -> this.presenter.removeChat(chatItem)))).allowBackpress(true))).show();
    }

    @Override
    public void onLinkClick(String link) {
        if (ClipboardUtils.copyToClipBoard(link)) {
            Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.integrations.copy_link.success"), (int)0).show();
        }
    }

    @Override
    public void onCallClick(String number) {
        if (number != null && Executor.canCall((Context)this)) {
            Executor.openCall((Context)this, number);
        } else {
            this.showPermissionDeniedToast();
        }
    }

    @Override
    public void onMessengerClick(String name) {
        this.presenter.fetchConnect(name);
    }

    @Override
    public void onSettingsClick() {
        IntentUtils.setNextActivity((Context)this, SettingsActivity.class).startActivity();
    }

    @Override
    public void onExitClick() {
        Action.invoke(ActionType.EXIT);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 21 && resultCode == 22) {
            this.startChat(Transition.NONE);
        }
    }

    private void activateWatermark() {
        this.watermark.setActivateState(true);
        this.dummyWatermark.setVisibility(0);
    }

    private void setWatermarkAlphaAnimation(int scrollPosition) {
        this.watermark.setOpacityState((float)(this.maxWidthLounge.getBottom() - this.scrollViewLounge.getHeight() - scrollPosition) < (float)this.watermark.getHeight() + Utils.dpToPx(100.0f));
    }

    private void showChats() {
        IntentUtils.setNextActivity((Context)this, ChatsActivity.class).startActivity();
    }

    private void startChat(Transition transition) {
        this.startChat(null, transition);
    }

    private void startChat(@Nullable String presetMessage, Transition transition) {
        ChatUtils.createChatActivityIntent((Activity)this).putExtra("chatPresetMessage", presetMessage).setTransition(transition).startActivityForResult(21);
    }

    private void startChat(ChatContentType contentType, @Nullable String contentId, Transition transition) {
        if (contentType == ChatContentType.USER_CHAT && contentId != null) {
            ChatUtils.createChatActivityIntent((Activity)this).putExtra("chatContentType", contentType.toString()).putExtra("chatContentId", contentId).setTransition(transition).startActivityForResult(21);
        }
    }

    private void showPermissionDeniedToast() {
        Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.permission.denied"), (int)1).show();
    }

    private void setLoungeMediaErrorViewDescription(@Nullable View errorView, String type) {
        if (errorView instanceof LoungeMediaErrorCardView) {
            ((LoungeMediaErrorCardView)errorView).setLoungeMediaType(type);
        }
    }
}

