/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.watermark;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;

public class ChannelWatermarkView
extends FrameLayout {
    private Context context;
    private View root;
    private boolean isActive = false;
    private boolean isVisible = false;

    public ChannelWatermarkView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_channel_watermark, (ViewGroup)this, true);
        this.root.setBackgroundColor(0);
        this.root.setOnClickListener(v -> {
            Channel channel = ChannelStore.get().channelState.get();
            if (channel != null) {
                IntentUtils.setUrl(this.context, String.format("https://channel.io/%s/?utm_source=%s&utm_medium=plugin&utm_campaign=android&utm_content=%s&utm_channel_id=%s", ((Language)((Object)((Object)SettingsStore.get().language.get()))).toString(), "plugin_watermark", channel.getName(), channel.getId())).startActivity();
            }
        });
    }

    public void setActivateState(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            if (isActive) {
                this.animate(this.isVisible ? 1.0f : 0.0f, 250L);
            } else {
                this.animate(0.0f, 0L);
            }
        }
    }

    public void setOpacityState(boolean isVisible) {
        if (this.isVisible != isVisible) {
            this.isVisible = isVisible;
            if (this.isActive) {
                this.animate(isVisible ? 1.0f : 0.0f, 250L);
            }
        }
    }

    private void animate(float alpha, long duration) {
        this.animate().alpha(alpha).setDuration(duration).start();
    }
}

