/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.activity.chat.binder.ChatHeaderBinder;
import com.zoyi.channel.plugin.android.activity.chat.binder.ChatInteractionBinder;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.enumerate.ChatState;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManagerInterface;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendActionItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendTextItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat2.ChatContract2;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.bind.BindAction;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.RxBus;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.repo.MessagesRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatRepo;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.selector.ChatSelector;
import com.zoyi.channel.plugin.android.selector.SocketSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.functions.Action1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatPresenter2
extends AbstractAdapterPresenter<ChatContract2.View, ChatAdapterContract.View, ChatAdapterContract.Model>
implements ChatContract2.Presenter {
    @Nullable
    private String chatId;
    @Nullable
    private String presetMessage;
    @Nullable
    private Session lastReadSession;
    @Nullable
    private String prev;
    private ChatState chatState = ChatState.DISCONNECTED;
    @Nullable
    private ArrayList<Message> tempQueue;
    @Nullable
    private ChatHeaderBinder chatHeaderBinder;
    @Nullable
    private ChatInteractionBinder chatInteractionBinder;
    @Nullable
    private Message lastMessage;

    public ChatPresenter2(ChatContract2.View view, ChatAdapterContract.View adapterView, ChatAdapterContract.Model adapterModel, @Nullable String chatId, @Nullable String presetMessage) {
        super(view, adapterView, adapterModel);
        this.chatId = chatId;
        this.presetMessage = presetMessage;
    }

    private ChatManagerInterface getChatManager() {
        return ChatManager.get(this.chatId);
    }

    @Override
    public void init() {
        ((ChatContract2.View)this.view).onFetchStateChange(FetchState.LOADING);
        if (this.chatId != null) {
            this.initUserChat();
        }
    }

    @Override
    public void createMarketingSupportBotUserChat() {
        if (this.chatInteractionBinder != null) {
            Message marketingMessage = this.chatInteractionBinder.getMarketingMessage();
            if (this.chatId != null && marketingMessage != null && marketingMessage.getMarketing() != null && !this.isRunning(BindAction.CREATE_CHAT)) {
                ((ChatContract2.View)this.view).showProgress();
                Api.createMarketingSupportBotUserChat(this.chatId, marketingMessage.getMarketing().getType(), marketingMessage.getMarketing().getId()).onComplete(() -> ((ChatContract2.View)this.view).hideProgress()).call(repo -> {
                    ((ChatAdapterContract.Model)this.adapterModel).addMessage(repo.getMessage());
                    if (this.chatInteractionBinder != null) {
                        this.chatInteractionBinder.setMarketingMessage(repo.getMessage());
                    }
                }).bind(this, BindAction.CREATE_CHAT);
            }
        }
    }

    private void initUserChat() {
        this.initUserChat(null);
    }

    private void initUserChat(@Nullable Message initMessage) {
        SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
            if (socketStatus == SocketStatus.READY) {
                this.fetchMessages();
            }
        })).bind(this, BindAction.BIND_SOCKET);
        if (this.chatId != null) {
            ChatSelector.bindHostTyping(this.chatId, (Action1<List<Typing>>)((Action1)typings -> ((ChatAdapterContract.Model)this.adapterModel).setTypings((List<Typing>)typings))).bind(this);
        }
        this.chatHeaderBinder = new ChatHeaderBinder((Action1<Boolean>)((Action1)showAssignee -> ((ChatContract2.View)this.view).switchHeader((boolean)showAssignee))).bind(this);
        this.chatInteractionBinder = new ChatInteractionBinder(initMessage, (Action1<ChatInteractionState>)((Action1)chatInteractionState -> ((ChatContract2.View)this.view).onChatInteractionStateChange((ChatInteractionState)((Object)chatInteractionState)))).bind(this);
        RxBus.bind((Action1<Object>)((Action1)this::onSocketReceived), this);
    }

    private void fetchMessages() {
        if (this.chatId != null) {
            this.chatState = ChatState.FETCHING;
            this.initQueue();
            Api.getMessages(this.chatId).onError(ex -> {
                this.chatState = ChatState.DISCONNECTED;
                if (ex.is4xxClientError()) {
                    ((ChatContract2.View)this.view).finish();
                } else {
                    ((ChatContract2.View)this.view).onFetchStateChange(FetchState.FAILED);
                }
                this.clearQueue();
            }).call(repo -> {
                Message lastMessage;
                this.chatState = ChatState.NEWEST;
                UserChatRepo userChatRepo = repo.getUserChatRepo();
                MessagesRepo messagesRepo = repo.getMessagesRepo();
                this.onUserChatChanged(userChatRepo.getUserChat());
                this.lastReadSession = userChatRepo.getSession();
                this.prev = messagesRepo.getNext();
                ArrayList<Message> appendMessages = new ArrayList<Message>(messagesRepo.getMessages());
                if (this.tempQueue != null) {
                    appendMessages.addAll(this.tempQueue);
                    this.clearQueue();
                }
                Collections.sort(appendMessages, (o1, o2) -> CompareUtils.compare(o1.getCreatedAt(), o2.getCreatedAt()));
                ((ChatAdapterContract.Model)this.adapterModel).setMessages(appendMessages, this.getChatManager().getUnsentItems(), this.lastReadSession, messagesRepo.getNext());
                Message message = lastMessage = messagesRepo.getPrev() != null || appendMessages.isEmpty() ? null : appendMessages.get(appendMessages.size() - 1);
                if (this.chatInteractionBinder != null) {
                    this.chatInteractionBinder.setMarketingMessage(lastMessage);
                }
                ((ChatContract2.View)this.view).scrollToBottom();
                ((ChatContract2.View)this.view).onFetchStateChange(FetchState.COMPLETE);
                ChatAction.read(this.chatId);
                if (messagesRepo.getNext() != null && !((ChatContract2.View)this.view).isScrollable()) {
                    this.fetchPrevMessages();
                }
            }).bind(this, BindAction.FETCH_MESSAGES);
        }
    }

    @Override
    public void fetchPrevMessages() {
        if (this.chatId != null && !this.isRunning(BindAction.FETCH_MESSAGES) && this.prev != null) {
            Api.getMessages2(this.chatId, this.prev, 30, "DESC").call(repo -> {
                this.prev = repo.getNext();
                ((ChatAdapterContract.Model)this.adapterModel).addMessages(repo.getMessages(), this.lastReadSession, repo.getNext());
                if (repo.getNext() != null && !((ChatContract2.View)this.view).isScrollable()) {
                    this.unbind(BindAction.FETCH_MESSAGES);
                    this.fetchPrevMessages();
                }
            }).bind(this, BindAction.FETCH_MESSAGES);
        }
    }

    private void onSocketReceived(Object object) {
        if (object instanceof UserChat) {
            UserChat userChat = (UserChat)object;
            if (this.chatId != null && this.chatId.equals(userChat.getId())) {
                this.onUserChatChanged(userChat);
            }
        }
        if (object instanceof Message) {
            Message message = (Message)object;
            if (this.chatId != null && this.chatId.equals(message.getChatId())) {
                this.onReceiveMessage(message);
            }
        }
    }

    private void onUserChatChanged(UserChat userChat) {
        if (userChat.isStateRemoved()) {
            ((ChatContract2.View)this.view).finish(Transition.NONE);
            return;
        }
        if (this.chatHeaderBinder != null) {
            this.chatHeaderBinder.setUserChat(userChat);
        }
        if (this.chatInteractionBinder != null) {
            this.chatInteractionBinder.setUserChat(userChat);
        }
        ((ChatContract2.View)this.view).onChatStateChange(userChat);
    }

    @Override
    protected void handleAction(ActionType actionType) {
        switch (actionType) {
            case SOCKET_DISCONNECTED: 
            case SHUTDOWN: {
                if (this.isRunning(BindAction.FETCH_MESSAGES)) {
                    ((ChatContract2.View)this.view).onFetchStateChange(FetchState.FAILED);
                    this.unbind(BindAction.FETCH_MESSAGES);
                }
                this.clearQueue();
                this.chatState = ChatState.DISCONNECTED;
                this.prev = null;
            }
        }
    }

    private void onReceiveMessage(Message message) {
        switch (this.chatState) {
            case NEWEST: {
                boolean isScrollOnBottom = ((ChatContract2.View)this.view).isScrollOnBottom();
                ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
                if (isScrollOnBottom) {
                    ((ChatContract2.View)this.view).scrollToBottom();
                } else if (!CompareUtils.isSame(message.getPersonType(), "user")) {
                    // empty if block
                }
                if (this.chatInteractionBinder == null) break;
                this.chatInteractionBinder.setMarketingMessage(message);
                break;
            }
            case FETCHING: {
                if (this.tempQueue == null) break;
                this.tempQueue.add(message);
            }
        }
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (CompareUtils.exists((Comparable)((Object)actionType), (Comparable[])new String[]{"userChat.solve", "userChat.close"}) && CompareUtils.isSame(actionButton.getKey(), "reopen")) {
            this.reopenChat(actionButton);
            return;
        }
        if (this.chatId != null) {
            this.getChatManager().sendMessage(new SendActionItem(this.chatId, actionType, actionButton));
        }
        ((ChatContract2.View)this.view).scrollToBottom();
    }

    private void reopenChat(@NonNull ActionButton actionButton) {
        Message message = actionButton.getMessage();
        message.clearAction();
        ((ChatAdapterContract.Model)this.adapterModel).addMessage(message);
        if (this.chatInteractionBinder != null) {
            this.chatInteractionBinder.setTemporaryInputOpened(true);
        }
        ((ChatContract2.View)this.view).scrollToBottom();
    }

    @Override
    public void deleteMessage(String messageId) {
        if (this.chatId != null) {
            Api.deleteMessage2(this.chatId, messageId).call(repo -> {
                if (repo.getMessage() != null) {
                    ((ChatAdapterContract.Model)this.adapterModel).updateItem(new ChatMessageItem(repo.getMessage()));
                }
            }).bind(this);
        }
    }

    @Override
    public void sendText(String message) {
        if (this.chatId != null) {
            this.getChatManager().sendMessage(new SendTextItem(this.chatId, message));
        }
        ((ChatContract2.View)this.view).scrollToBottom();
    }

    @Override
    public void resend(SendItem item) {
        if (this.chatId != null) {
            this.getChatManager().resend(item);
        }
        ((ChatContract2.View)this.view).scrollToBottom();
    }

    @Override
    public void removeFailedItem(SendItem item) {
        this.getChatManager().remove(item);
    }

    @Override
    public void uploadFiles(List<PhotoItem> photoItems) {
        if (photoItems != null) {
            List items = Stream.of(photoItems).mapIndexed((index, item) -> new SendFileItem(this.chatId, index, item.getUri(), item.getName(), item.getSize())).toList();
            if (this.chatId != null) {
                this.getChatManager().sendMessages(items);
            }
            ((ChatContract2.View)this.view).scrollToBottom();
        }
    }

    @Override
    public void cancelSendingFile(SendFileItem item) {
        if (item.getType() == MessageType.FAILED_FILE) {
            this.removeFailedItem(item);
        } else {
            this.getChatManager().cancelRecentSendingFile();
        }
    }

    private void initQueue() {
        this.clearQueue();
        this.tempQueue = new ArrayList();
    }

    private void clearQueue() {
        if (this.tempQueue != null) {
            this.tempQueue.clear();
            this.tempQueue = null;
        }
    }
}

