/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat2;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.dialog.ReactionsDialog;
import com.zoyi.channel.plugin.android.activity.chat.listener.ChatInteractionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChatActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.utils.KeyboardUtils;
import com.zoyi.channel.plugin.android.activity.chat.view.chat.ChatInteractionView;
import com.zoyi.channel.plugin.android.activity.chat.view.chat.NewMessageAlertView;
import com.zoyi.channel.plugin.android.activity.chat.view.navigation.HostHeaderView;
import com.zoyi.channel.plugin.android.activity.chat2.ChatContract2;
import com.zoyi.channel.plugin.android.activity.chat2.ChatPresenter2;
import com.zoyi.channel.plugin.android.activity.common.navigation.ChannelInfoNavigationView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.ChatStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.store.TypingStore;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.IconButtonBottomSheetDialog;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.load_wrapper.LoadWrapperLayout;
import com.zoyi.channel.plugin.android.view.scrollview.RecyclerBottomPlaceholderLayout;
import com.zoyi.channel.plugin.android.view.toast.DateToastView;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChatActivity2
extends BaseActivity2
implements ChatContract2.View,
ChatInteractionListener,
OnMessageContentClickListener,
OnChatActionListener {
    private NavigationView navigation;
    private ChannelInfoNavigationView channelHeader;
    private HostHeaderView hostHeader;
    private LoadWrapperLayout loaderChat;
    private ChatInteractionView inputViewContainer;
    private RecyclerView recyclerView;
    private NewMessageAlertView newMessageAlertView;
    private DateToastView dateToastView;
    private RecyclerBottomPlaceholderLayout bottomPlaceholder;
    private ChatAdapter adapter;
    private LinearLayoutManager layoutManager;
    private ChatContract2.Presenter presenter;
    @Nullable
    private KeyboardUtils keyboardUtils;
    @Nullable
    private Subscription toastSubscription;
    private PublishSubject<Integer> toastPublishSubject = PublishSubject.create();

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_chat2);
        String contentId = (String)Optional.ofNullable((Object)this.getIntent()).map(intent -> intent.getStringExtra("chatContentId")).orElse(null);
        String presetMessage = (String)Optional.ofNullable((Object)this.getIntent()).map(intent -> intent.getStringExtra("chatPresetMessage")).orElse(null);
        this.navigation = (NavigationView)this.findViewById(R.id.ch_navigationChat);
        this.navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));
        this.channelHeader = (ChannelInfoNavigationView)this.findViewById(R.id.ch_navigationChatChannel);
        this.hostHeader = (HostHeaderView)this.findViewById(R.id.ch_navigationChatHost);
        this.hostHeader.setVisibility(8);
        this.loaderChat = (LoadWrapperLayout)this.findViewById(R.id.ch_loaderChat);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.ch_recyclerViewChat);
        this.newMessageAlertView = (NewMessageAlertView)this.findViewById(R.id.ch_viewNewMessageAlert);
        this.newMessageAlertView.setListener(() -> {
            this.scrollToBottom();
            this.newMessageAlertView.hide();
        });
        this.dateToastView = (DateToastView)this.findViewById(R.id.ch_viewChatDateToast);
        this.inputViewContainer = (ChatInteractionView)this.findViewById(R.id.ch_viewChatInput);
        this.inputViewContainer.setChatInteractionListener(this);
        this.adapter = new ChatAdapter(this);
        this.adapter.setOnMessageContentClickListener(this);
        this.presenter = new ChatPresenter2(this, this.adapter, this.adapter, contentId, presetMessage);
        this.layoutManager = new LinearLayoutManager((Context)this){

            public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
                return false;
            }
        };
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(){

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity2.this.newMessageAlertView.hide();
            }

            @Override
            public void scrollAttachedToTop() {
                ChatActivity2.this.presenter.fetchPrevMessages();
            }
        });
        this.bottomPlaceholder = (RecyclerBottomPlaceholderLayout)this.findViewById(R.id.ch_bottomLayoutChat);
        this.bottomPlaceholder.setRecyclerView(this.recyclerView);
        this.bottomPlaceholder.setStackFromEnd(true);
        this.bottomPlaceholder.setOnSizeChangeListener(height -> {
            ViewGroup.LayoutParams params = this.newMessageAlertView.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)params).setMargins(0, 0, 0, height);
            }
        });
        this.keyboardUtils = new KeyboardUtils(this, (View)this.loaderChat, this.recyclerView);
        this.keyboardUtils.enable();
        this.toastSubscription = this.toastPublishSubject.throttleLast(250L, TimeUnit.MILLISECONDS).onBackpressureLatest().observeOn(AndroidSchedulers.mainThread()).subscribe(integer2 -> this.showFirstMessageDate(this.adapter.getItem((int)integer2)));
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                if (dy != 0 && ChatActivity2.this.toastPublishSubject != null && recyclerView.getLayoutManager() != null) {
                    ChatActivity2.this.toastPublishSubject.onNext((Object)((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition());
                }
            }
        });
        this.bindPresenter(this.presenter);
        return true;
    }

    protected void onPause() {
        super.onPause();
        KeyboardUtils.hideKeyboard((Activity)this);
        if (this.isFinishing()) {
            ChatStore.get().reset();
            TranslationStore.get().reset();
            ProfileBotStore.get().reset();
            TypingStore.get().reset();
            Action.invoke(ActionType.CHAT_CLOSED);
        }
    }

    @Override
    protected void onDestroy() {
        this.recyclerView.setAdapter(null);
        if (this.keyboardUtils != null) {
            this.keyboardUtils.disable();
        }
        if (this.toastSubscription != null && !this.toastSubscription.isUnsubscribed()) {
            this.toastSubscription.unsubscribe();
        }
        this.keyboardUtils = null;
        this.toastSubscription = null;
        super.onDestroy();
    }

    @Override
    public void onFetchStateChange(FetchState fetchState) {
        this.loaderChat.setLoadState(fetchState);
    }

    @Override
    public void switchHeader(boolean showAssignee) {
        Views.setVisibility((View)this.channelHeader, !showAssignee);
        Views.setVisibility((View)this.hostHeader, showAssignee);
    }

    @Override
    public void onChatStateChange(UserChat userChat) {
        this.inputViewContainer.initUserChat(userChat.getId());
        this.hostHeader.attachUserChat(userChat.getId());
    }

    @Override
    public void onChatInteractionStateChange(ChatInteractionState inputType) {
        if (this.inputViewContainer != null) {
            this.inputViewContainer.setState(inputType);
        }
    }

    @Override
    public boolean isScrollOnBottom() {
        return !this.recyclerView.canScrollVertically(1);
    }

    @Override
    public void scrollToBottom() {
        this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
    }

    @Override
    public boolean isScrollable() {
        return this.recyclerView.canScrollVertically(1) || this.recyclerView.canScrollVertically(-1);
    }

    @Override
    public void onAttachmentButtonClick() {
        IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
    }

    @Override
    public void onSendClick(String message) {
        if (this.presenter != null) {
            this.presenter.sendText(message);
        }
    }

    @Override
    public void startNewChat(int resultCode, Transition transition) {
        this.finish(resultCode, transition);
    }

    @Override
    public void startMarketingSupportBot() {
        if (this.presenter != null) {
            this.presenter.createMarketingSupportBotUserChat();
        }
    }

    @Override
    @Nullable
    public Dialog onMessageLongClick(Message message) {
        IconButtonBottomSheetDialog dialog = new IconButtonBottomSheetDialog((Context)this);
        if (message != null) {
            if (!message.getPlainText().isEmpty()) {
                dialog.addButton(R.drawable.ch_copy, ResUtils.getString("ch.chat.message.actions.copy_message"), () -> this.copyText(message.getPlainText()));
            }
            if (!message.isDeleted() && message.getPersonType() != null && message.getPersonType().equals("user") && message.getChatId() != null && message.getId() != null && message.getLog() == null) {
                dialog.addButton(R.drawable.ch_trash, ResUtils.getString("ch.chat.message.actions.delete_message"), R.color.ch_red400, R.color.ch_red400, () -> this.deleteMessage(message.getId()));
            }
            if (dialog.getButtons().size() > 0) {
                return dialog;
            }
        }
        return null;
    }

    @Override
    public void onReactionsLongClicked(List<Reaction> reactions) {
        new ReactionsDialog((Context)this, reactions).show();
    }

    @Override
    public void onMarketingAction(Marketing marketing, @Nullable String url) {
        MarketingAction.sendClickEvent(marketing, url);
    }

    @Override
    public void onOpenVideoClick(File attachment, long startAt) {
        Executor.startFullScreenVideo((Context)this, attachment, startAt);
    }

    @Override
    public void onAttachmentClick(File attachment, Message message) {
        if (attachment.isImage()) {
            IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("attachementId", attachment.getId()).putExtra("storageId", PhotoAlbumStorage.getInstance().save(message.getFiles())).startActivity();
        } else {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", attachment.getUrl()).putExtra("filename", attachment.getName()).putExtra("EXTRA_TYPE", attachment.getType()).setTransition(Transition.NONE).startActivity();
        }
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (this.presenter != null) {
            this.presenter.onActionClick(actionType, actionButton);
        }
    }

    @Override
    public void onResendButtonClick(SendItem sendItem) {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString("ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString("ch.chat.retry_sending_message"), (dialog12, which) -> {
            if (this.presenter != null) {
                this.presenter.resend(sendItem);
            }
        }).setNegativeButton((CharSequence)ResUtils.getString("ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString("ch.chat.delete"), (dialog1, which) -> {
            if (this.presenter != null) {
                this.presenter.removeFailedItem(sendItem);
            }
        }).setCancelable(true).create();
        dialog.setOnShowListener(args -> {
            int dark = ContextCompat.getColor((Context)this, (int)R.color.ch_grey900);
            int cobalt = ContextCompat.getColor((Context)this, (int)R.color.ch_cobalt400);
            dialog.getButton(-1).setTextColor(cobalt);
            dialog.getButton(-2).setTextColor(dark);
            dialog.getButton(-3).setTextColor(dark);
        });
        dialog.show();
    }

    @Override
    public void onCancelClick(@Nullable SendFileItem sendFileItem) {
        if (sendFileItem != null) {
            this.presenter.cancelSendingFile(sendFileItem);
        }
    }

    @Override
    public void onUrlClick(String url) {
        Executor.executeLinkAction((Context)this, url, LinkType.URL);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.uploadFiles(data.getParcelableArrayListExtra("PHOTO_INTENT_KEY"));
            }
        }
    }

    private void copyText(String text) {
        if (ClipboardUtils.copyToClipBoard(text)) {
            Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.copy_message.success"), (int)0).show();
        }
    }

    private void showFirstMessageDate(@Nullable MessageItem item) {
        if (item != null && this.dateToastView != null) {
            switch (item.getType()) {
                case HOST: 
                case USER: {
                    ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                    if (chatMessageItem.getCreatedAt() == 0L) break;
                    this.dateToastView.show(chatMessageItem.getCreatedAt());
                }
            }
        }
    }

    private void deleteMessage(String messageId) {
        ((ChannelDialog)((Object)((ChannelDialog)((Object)((ChannelDialog)((Object)new ChannelDialog((Context)this).setTitle(ResUtils.getString("ch.chat.message.delete_confirm.title")))).setDescription(ResUtils.getString("ch.chat.message.delete_confirm.message")).addButton(ButtonType.CANCEL))).addButton(ResUtils.getString("ch.chat.delete"), ResUtils.getColor(R.color.ch_red400), v -> {
            if (this.presenter != null) {
                this.presenter.deleteMessage(messageId);
            }
        }))).show();
    }
}

