/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnLinkButtonActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebPageContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.attachment.AttachmentsLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.AbsMessageTextView;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.GiantEmojiTextView;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.ReactionsView;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.TranslationContentView;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.WebPageContentView;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.AbsMessageHolder;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.model.etc.TranslationInfo;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.functions.Action1;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMessageHolder
extends AbsMessageHolder
implements OnBaseMessageActionListener,
OnWebPageContentActionListener,
OnAttachmentContentActionListener,
OnLinkButtonActionListener,
View.OnLongClickListener {
    protected AbsMessageTextView textMessage;
    protected Context context;
    private LinearLayout rootLayout;
    private AttachmentsLayout viewMessageContentAttachments;
    private WebPageContentView viewMessageContentWebPage;
    private TranslationContentView viewMessageContentTranslation;
    private ReactionsView viewMessageContentReactions;
    private GiantEmojiTextView viewMessageContentGiantEmoji;
    private List<MessageContentView> contents;
    @Nullable
    private OnBaseMessageActionListener listener;
    @Nullable
    private Binder translationBinder;

    BaseMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
        super(itemView);
        this.context = itemView.getContext();
        this.listener = listener;
        this.rootLayout = (LinearLayout)itemView.findViewById(R.id.ch_rootMessageHolder);
        this.rootLayout.setOnLongClickListener((View.OnLongClickListener)this);
        this.textMessage = (AbsMessageTextView)itemView.findViewById(R.id.ch_viewMessageHolderText);
        this.textMessage.setLinkButtonActionListener(this);
        this.viewMessageContentTranslation = (TranslationContentView)itemView.findViewById(R.id.ch_viewMessageContentTranslation);
        this.viewMessageContentAttachments = (AttachmentsLayout)itemView.findViewById(R.id.ch_viewMessageContentAttachments);
        this.viewMessageContentWebPage = (WebPageContentView)itemView.findViewById(R.id.ch_viewMessageContentWebPage);
        this.viewMessageContentWebPage.setOnWebPageActionListener(this);
        this.viewMessageContentReactions = (ReactionsView)itemView.findViewById(R.id.ch_viewMessageContentReactions);
        this.viewMessageContentReactions.setOnLongClickListener(v -> {
            this.onReactionsLongClicked();
            return true;
        });
        this.viewMessageContentGiantEmoji = (GiantEmojiTextView)itemView.findViewById(R.id.ch_viewMessageContentGiantEmoji);
        this.contents = new ArrayList<MessageContentView>();
        this.contents.add(this.viewMessageContentTranslation);
        this.contents.add(this.viewMessageContentAttachments);
        this.contents.add(this.viewMessageContentWebPage);
        this.contents.add(this.viewMessageContentReactions);
        this.contents.add(this.viewMessageContentGiantEmoji);
    }

    @Override
    public void bind(Long createdAt, boolean showDate, boolean isHead, boolean isTail) {
        super.bind(createdAt, showDate, isHead, isTail);
        Stream.ofNullable(this.contents).forEach(content -> {
            if (content != null) {
                content.clear();
                content.resetView();
                content.setVisibility(8);
            }
        });
        if (this.textMessage != null) {
            this.textMessage.setHead(isHead);
            this.textMessage.initViews();
        }
    }

    protected void setGravity(int gravity) {
        if (this.viewMessageContentWebPage != null) {
            this.viewMessageContentWebPage.setGravity(gravity);
        }
        if (this.viewMessageContentAttachments != null) {
            this.viewMessageContentAttachments.setGravity(gravity);
        }
    }

    protected void setText(@Nullable CharSequence text) {
        if (this.textMessage != null && text != null) {
            this.textMessage.setVisibility(0);
            this.textMessage.setText(text);
        }
    }

    protected void setBlocks(@Nullable List<Block> blocks) {
        if (this.textMessage != null && blocks != null) {
            this.textMessage.setVisibility(0);
            this.textMessage.setBlocks(blocks);
        }
    }

    protected void setGiantEmoji(Block blocks) {
        if (this.viewMessageContentGiantEmoji != null) {
            this.viewMessageContentGiantEmoji.setVisibility(0);
            this.viewMessageContentGiantEmoji.setText((CharSequence)blocks.getFormattedSpanMessage());
        }
    }

    protected void setLinkButtons(@Nullable List<Button> buttons) {
        if (this.textMessage != null && buttons != null && buttons.size() > 0) {
            this.textMessage.setVisibility(0);
            this.textMessage.setLinkButtons(buttons);
        }
    }

    protected void setDeleteMessage() {
        if (this.textMessage != null) {
            this.textMessage.setVisibility(0);
            this.textMessage.setDelete();
        }
    }

    protected void setWebPage(@Nullable String messageId, WebPage webPage) {
        if (this.viewMessageContentWebPage != null) {
            this.viewMessageContentWebPage.setVisibility(0);
            this.viewMessageContentWebPage.setWebPage(messageId, webPage);
        }
    }

    protected void setAttachments(@Nullable String messageId, @Nullable List<File> attachments, @Nullable OnAttachmentContentActionListener listener) {
        if (this.viewMessageContentAttachments != null) {
            this.viewMessageContentAttachments.resetView();
            if (messageId != null && ListUtils.hasItems(attachments)) {
                this.viewMessageContentAttachments.setVisibility(0);
                this.viewMessageContentAttachments.setAttachments(messageId, attachments, listener);
            }
        }
    }

    protected void setReactions(@Nullable List<Reaction> reactions) {
        if (this.viewMessageContentReactions != null && reactions != null) {
            this.viewMessageContentReactions.setVisibility(0);
            this.viewMessageContentReactions.setReactions(reactions);
        }
    }

    protected void setTranslation(@Nullable String chatId, @Nullable String messageId, String language, @Nullable List<Block> blocks) {
        if (this.viewMessageContentTranslation != null) {
            this.viewMessageContentTranslation.setVisibility(0);
            this.viewMessageContentTranslation.bind(chatId, messageId, language);
            this.translationBinder = TranslationSelector.bindTranslation(TranslationInfo.createKey(chatId, messageId, language), (Action1<TranslationInfo>)((Action1)translationInfo -> {
                if (translationInfo != null && translationInfo.getState() == TranslationState.TRANSLATED && translationInfo.getBlocks() != null) {
                    this.textMessage.setVisibility(0);
                    this.textMessage.setBlocks(translationInfo.getBlocks());
                } else if (blocks != null) {
                    this.textMessage.setVisibility(0);
                    this.textMessage.setBlocks(blocks);
                }
            }));
        }
    }

    public boolean onLongClick(View v) {
        return false;
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        if (this.listener != null) {
            this.listener.onActionClick(actionType, actionButton);
            if (this.getMarketing() != null) {
                this.listener.onMarketingAction(this.getMarketing(), null);
            }
        }
    }

    @Override
    public void onUrlClick(String url) {
        if (this.listener != null) {
            this.listener.onUrlClick(url);
            if (this.getMarketing() != null) {
                this.listener.onMarketingAction(this.getMarketing(), url);
            }
        }
    }

    @Override
    public void onWebPageClick(String url) {
        if (this.listener != null) {
            this.listener.onUrlClick(url);
            if (this.getMarketing() != null) {
                this.listener.onMarketingAction(this.getMarketing(), url);
            }
        }
    }

    @Override
    public void onWebPageLongClick() {
    }

    @Override
    public void onOpenVideoClick(File attachment, long startAt) {
        if (this.listener != null) {
            this.listener.onOpenVideoClick(attachment, startAt);
            if (this.getMarketing() != null) {
                this.listener.onMarketingAction(this.getMarketing(), null);
            }
        }
    }

    @Override
    public void onAttachmentClick(File attachment) {
        if (this.listener != null && this.getMarketing() != null) {
            this.listener.onMarketingAction(this.getMarketing(), null);
        }
    }

    @Override
    public void onAttachmentClick(File attachment, Message message) {
        if (this.listener != null) {
            this.listener.onAttachmentClick(attachment, message);
            if (this.getMarketing() != null) {
                this.listener.onMarketingAction(this.getMarketing(), null);
            }
        }
    }

    @Override
    public void onAttachmentActionClick() {
        if (this.listener != null && this.getMarketing() != null) {
            this.listener.onMarketingAction(this.getMarketing(), null);
        }
    }

    @Override
    public void onAttachmentLongClick() {
    }

    @Override
    public void onLinkButtonClick(String link) {
        if (this.listener != null) {
            if (UriUtils.isMailToUri(link)) {
                Executor.openEmail(this.context, link.substring("mailto:".length()));
            } else if (UriUtils.isTelUri(link)) {
                Executor.openCall(this.context, link.substring("tel:".length()));
            } else {
                this.listener.onUrlClick(link);
            }
            if (this.getMarketing() != null) {
                this.listener.onMarketingAction(this.getMarketing(), link);
            }
        }
    }

    @Override
    public void onLinkButtonLongClick() {
    }

    @Override
    public void onMarketingAction(Marketing marketing, @Nullable String url) {
        if (this.listener != null) {
            this.listener.onMarketingAction(marketing, url);
        }
    }

    protected void onReactionsLongClicked() {
    }

    @Nullable
    protected abstract Marketing getMarketing();

    @Override
    protected void onRecycled() {
        super.onRecycled();
        Stream.ofNullable(this.contents).forEach(content -> {
            if (content != null) {
                content.clear();
            }
        });
        if (this.translationBinder != null) {
            this.translationBinder.unbind();
            this.translationBinder = null;
        }
    }
}

