/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.chat;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.ChatInteractionListener;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.store.TypingStore;
import com.zoyi.channel.plugin.android.store.TypingTextSaveStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ChatInteractionView
extends LinearLayout {
    private Context context;
    private View viewChatBlocked;
    private ChatStartButton buttonNewChat;
    private LinearLayout layoutInteractionContent;
    private View layoutChatInput;
    private View buttonAttach;
    private WatchedEditText editChat;
    private View buttonSend;
    private View buttonMarketingSupportBot;
    @Nullable
    private String userChatId;
    @Nullable
    private ChatInteractionListener chatInteractionListener;
    private ChatInteractionState chatInteractionState = ChatInteractionState.NONE;

    public ChatInteractionView(Context context) {
        super(context);
        this.init(context);
    }

    public ChatInteractionView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChatInteractionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_chat_interaction, (ViewGroup)this, true);
        this.buttonNewChat = (ChatStartButton)view.findViewById(R.id.ch_buttonChatInteractionStartNewChat);
        this.buttonNewChat.setOnClickListener(v -> {
            if (this.chatInteractionListener != null) {
                this.chatInteractionListener.startNewChat(22, Transition.NONE);
            }
        });
        this.layoutInteractionContent = (LinearLayout)view.findViewById(R.id.ch_layoutChatInteractionContent);
        this.buttonMarketingSupportBot = view.findViewById(R.id.ch_buttonChatInteractionMarketingSupportBot);
        this.buttonMarketingSupportBot.setOnClickListener(v -> {
            if (this.chatInteractionListener != null) {
                this.chatInteractionListener.startMarketingSupportBot();
            }
        });
        this.viewChatBlocked = view.findViewById(R.id.ch_textChatInteractionBlocked);
        this.layoutChatInput = view.findViewById(R.id.ch_layoutChatInteractionInput);
        this.buttonAttach = view.findViewById(R.id.ch_buttonChatInteractionAttach);
        this.buttonAttach.setOnClickListener(v -> {
            if (this.chatInteractionListener != null) {
                this.chatInteractionListener.onAttachmentButtonClick();
            }
        });
        this.editChat = (WatchedEditText)view.findViewById(R.id.ch_editChatInteraction);
        this.buttonSend = view.findViewById(R.id.ch_buttonChatInteractionSend);
        this.buttonSend.setEnabled(true);
        this.buttonSend.setOnClickListener(v -> {
            String newString = StringUtils.stripEnd(this.editChat.getString(), null);
            if (this.chatInteractionListener != null && !TextUtils.isEmpty((CharSequence)newString)) {
                this.chatInteractionListener.onSendClick(newString);
            }
            this.editChat.setText("");
        });
        this.editChat.setWatchedTextChangedListener(s -> {
            boolean isEnabled;
            TypingStore.get().typingState.set(!TextUtils.isEmpty((CharSequence)s));
            if (TextUtils.isEmpty((CharSequence)s)) {
                TypingStore.get().myTypingState.remove(Typing.dummy());
            } else {
                TypingStore.get().myTypingState.upsert(Typing.dummy());
            }
            String newString = StringUtils.stripEnd(s, null);
            boolean bl = isEnabled = !TextUtils.isEmpty((CharSequence)newString);
            if (isEnabled != this.buttonSend.isEnabled()) {
                this.buttonSend.setEnabled(isEnabled);
            }
            if (this.userChatId != null) {
                TypingTextSaveStore.get().savedTexts.upsert((Pair<String, String>)new Pair((Object)this.userChatId, (Object)s));
            }
        });
        this.editChat.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                this.setInputDim(false);
                ProfileBotStore.get().requestFocus.set(false);
            }
        });
    }

    public void initUserChat(String userChatId) {
        if (this.userChatId == null) {
            this.userChatId = userChatId;
            Pair<String, String> pair = TypingTextSaveStore.get().savedTexts.get(userChatId);
            if (pair != null && pair.second != null) {
                this.editChat.setText((CharSequence)pair.second);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        TypingStore.get().typingState.set(false);
    }

    public void setChatInteractionListener(@Nullable ChatInteractionListener chatInteractionListener) {
        this.chatInteractionListener = chatInteractionListener;
    }

    public void setInputDim(boolean enabled) {
        this.layoutChatInput.setBackgroundColor(ResUtils.getColor(enabled ? R.color.ch_grey200 : R.color.ch_white));
    }

    public void setState(ChatInteractionState chatInteractionState) {
        if (this.chatInteractionState != chatInteractionState) {
            this.chatInteractionState = chatInteractionState;
            Views.setVisibility((View)this.buttonNewChat, false);
            Views.setVisibility((View)this.layoutInteractionContent, false);
            Views.setVisibility(this.buttonMarketingSupportBot, false);
            Views.setVisibility(this.viewChatBlocked, false);
            Views.setVisibility(this.layoutChatInput, false);
            switch (chatInteractionState) {
                case NORMAL: {
                    Views.setVisibility((View)this.layoutInteractionContent, true);
                    Views.setVisibility(this.layoutChatInput, true);
                    break;
                }
                case MARKETING_SUPPORT_BOT: {
                    Keyboard.close(this.context, (View)this.editChat);
                    Views.setVisibility((View)this.layoutInteractionContent, true);
                    Views.setVisibility(this.buttonMarketingSupportBot, true);
                    break;
                }
                case DISABLE: {
                    Keyboard.close(this.context, (View)this.editChat);
                    Views.setVisibility((View)this.layoutInteractionContent, true);
                    Views.setVisibility(this.viewChatBlocked, true);
                    break;
                }
                case NEW_CHAT_START: {
                    Keyboard.close(this.context, (View)this.editChat);
                    Views.setVisibility((View)this.buttonNewChat, true);
                    break;
                }
                case NONE: {
                    Keyboard.close(this.context, (View)this.editChat);
                }
            }
        }
    }

    public void setFocus() {
        this.editChat.requestFocus();
    }
}

