package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.net.Uri;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.upstream.*;
import com.zoyi.com.google.android.exoplayer2.util.Util;

import java.util.ArrayList;
import java.util.List;

public class ExoPlayerManager {

  private static ExoPlayerManager exoPlayerManager;
  private SimpleExoPlayer player;

  private List<Playable> playables;

  public static ExoPlayerManager getInstance(Context context, Playable playable) {
    if (exoPlayerManager == null) {
      exoPlayerManager = new ExoPlayerManager(context);
    }

    exoPlayerManager.addPlayable(playable);

    return exoPlayerManager;
  }

  private ExoPlayerManager(Context context) {
    BandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
    TrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory(bandwidthMeter);
    TrackSelector trackSelector = new DefaultTrackSelector(videoTrackSelectionFactory);

    player = ExoPlayerFactory.newSimpleInstance(context, new DefaultRenderersFactory(context), trackSelector);
    playables = new ArrayList<>();
  }

  public SimpleExoPlayer playVideo(Context context, String url, Playable currentPlayable, long lastPosition) {
    for (Playable playable : playables) {
      if (playable != null && playable != currentPlayable) {
        playable.onStop();
      }
    }

    stopVideo();

    DefaultHttpDataSourceFactory dataSourceFactory = new DefaultHttpDataSourceFactory(
        Util.getUserAgent(context, "ChannelTalkSDK")
    );
    dataSourceFactory.getDefaultRequestProperties().set(Const.X_SESSION, GlobalStore.get().jwt.get());

    MediaSource videoSource = new ExtractorMediaSource.Factory(dataSourceFactory).createMediaSource(Uri.parse(url));
    player.prepare(videoSource);

    player.seekTo(lastPosition);
    player.setPlayWhenReady(true);

    currentPlayable.onPlay();

    return player;
  }

  private void stopVideo() {
    player.setPlayWhenReady(false);
  }

  public void stopVideo(Playable playable) {
    playable.onStop();
    removePlayable(playable);
    stopVideo();
  }

  private void addPlayable(Playable playable) {
    if (!this.playables.contains(playable)) {
      this.playables.add(playable);
    }
  }

  public void removePlayable(Playable playable) {
    this.playables.remove(playable);
  }

  public interface Playable {

    void onPlay();

    void onStop();

  }
}
