package com.zoyi.channel.plugin.android.store.binder;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.store.state.BaseState;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;

public class Binder1<E> extends Binder {

  private BaseState<E> state1;

  private E lastValue = null;

  @Nullable
  private Subscription subscription1;

  public Binder1(BaseState<E> state1) {
    this.state1 = state1;
  }

  public Binder bind(Action1<E> action1) {
    this.subscription1 = this.state1.attach(action1);

    action1.call(state1.get());

    return this;
  }

  public Binder bind(Action2<E, E> action2) {
    this.subscription1 = this.state1.attach(newValue -> {
      action2.call(newValue, lastValue);

      this.lastValue = newValue;
    });

    this.lastValue = state1.get();

    action2.call(state1.get(), null);

    return this;
  }

  @Override
  public void unbind() {
    if (subscription1 != null && !subscription1.isUnsubscribed()) {
      subscription1.unsubscribe();
    }
    subscription1 = null;
  }
}
