package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.store.binder.Binder2;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.rx.functions.Action1;

public class PopupSelector {

  public static Binder bindPopup(Action1<Message> action1) {
    State<Message> popupMessageState = PopupStore.get().popupMessage;
    BooleanState hidePopupState = SettingsStore.get().hidePopup;

    return new Binder2<>(popupMessageState, hidePopupState)
        .bind((message, hidePopup) -> {
          if (message != null && !hidePopup) {
            action1.call(message);
          } else {
            action1.call(null);
          }
        });
  }
}
