package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.model.*;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.*;
import com.zoyi.channel.plugin.android.store.state.*;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.rx.functions.*;

import java.util.*;

public class ChatSelector {

  public static Binder bindWelcomeMessage(@Nullable String presetMessage, Action4<FetchState, SupportBotEntry, CharSequence, String> action4) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<FetchState> pluginFetchState = PluginStore.get().pluginFetchState;

    State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;
    State<FetchState> supportBotFetchState = SupportBotStore.get().supportBotFetchState;

    EnumState<Language> languageState = SettingsStore.get().language;

    return new Binder5<>(
        pluginState,
        pluginFetchState,
        supportBotState,
        supportBotFetchState,
        languageState
    ).bind((plugin, pluginFetch, supportBotEntry, supportBotFetch, language) -> {
      if (presetMessage != null) {
        action4.call(FetchState.COMPLETE, null, MessageUtils.createWelcomeMessage(plugin, language), presetMessage);
        return;
      }
      if (supportBotFetch != FetchState.COMPLETE) {
        action4.call(supportBotFetch, null, null, null);
        return;
      }
      if (supportBotEntry != null) {
        action4.call(FetchState.COMPLETE, supportBotEntry, null, null);
        return;
      }
      if (pluginFetch != FetchState.COMPLETE) {
        action4.call(pluginFetch, null, null, null);
        return;
      }
      if (plugin != null) {
        action4.call(FetchState.COMPLETE, null, MessageUtils.createWelcomeMessage(plugin, language), null);
        return;
      }
      action4.call(FetchState.FAILED, null, null, null);
    });
  }

  @Deprecated
  public static Binder bindChat(@Nullable String chatId, Action5<UserChat, Message, Boolean, Boolean, Boolean> action5) {
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    State<Channel> channelState = ChannelStore.get().channelState;
    BooleanState typingState = TypingStore.get().typingState;
    State<Long> nowState = TimerStore.get().now;
    BooleanState temporaryInputOpenedState = ChatStore.get().temporaryInputOpenedState;
    MapState<String, Message> messageState = UserChatStore.get().messages;

    return new Binder6<>(userChatsState, channelState, typingState, nowState, temporaryInputOpenedState, messageState).bind(
        (userChats, channel, isTyping, now, temporaryInputOpened, messages) -> {
          if (userChats.containsKey(chatId) && userChats.get(chatId) != null) {
            action5.call(
                userChats.get(chatId),
                messages.get(chatId),
                ChannelSelector.shouldAcceptAction(channel, now, isTyping),
                temporaryInputOpened,
                ChannelUtils.isWorking(channel, now)
            );
          }
        });
  }

  public static Binder bindTyping(Action1<Boolean> action1) {
    EnumState<SocketStatus> socketStatusState = SocketStore.get().socketState;
    ExpirableEntityMapState<Typing> myTypingState = TypingStore.get().myTypingState;

    return new Binder2<>(socketStatusState, myTypingState).bind((socketStatus, myTyping) -> {
      if (socketStatus == SocketStatus.READY) {
        action1.call(myTyping != null && myTyping.size() > 0);
      }
    });
  }

  public static Binder bindHostTyping(String chatId, Action1<List<Typing>> action1) {
    ExpirableEntityMapState<Typing> hostTypingState = TypingStore.get().hostTypingState;

    return new Binder1<>(hostTypingState).bind(typingMap -> {
      List<Typing> typings = new ArrayList<>();

      for (Typing typing : typingMap.values()) {
        if (typing != null && typing.getChatId() != null && typing.getChatId().equals(chatId)) {
          typings.add(typing);
        }
      }

      Collections.sort(typings, (o1, o2) -> CompareUtils.compare(o1.getCreatedAt(), o2.getCreatedAt()));

      action1.call(typings);
    });
  }

  @Nullable
  public static InitMessageItem getLocalMessage(@Nullable String presetMessage) {
    Plugin plugin = PluginStore.get().pluginState.get();
    FetchState pluginFetch = PluginStore.get().pluginFetchState.get();

    SupportBotEntry supportBotEntry = SupportBotStore.get().supportBotState.get();
    FetchState supportBotFetch = SupportBotStore.get().supportBotFetchState.get();

    Language language = SettingsStore.get().language.get();

    CharSequence welcomeMessage = MessageUtils.createWelcomeMessage(plugin, language);

    if (plugin == null || plugin.getId() == null) {
      return null;
    } else if (presetMessage != null) {
      return new WelcomeMessageItem(welcomeMessage);
    } else if (supportBotFetch == FetchState.COMPLETE && supportBotEntry != null) {
      return new SupportBotMessageItem(supportBotEntry);
    } else if (pluginFetch == FetchState.COMPLETE && plugin != null) {
      return new WelcomeMessageItem(welcomeMessage);
    }
    return null;
  }
}
