package com.zoyi.channel.plugin.android.open.config;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.open.model.Profile;
import com.zoyi.channel.plugin.android.open.option.ChannelButtonOption;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.com.google.gson.*;
import com.zoyi.com.google.gson.annotations.SerializedName;

/*
 * To save to preference, add @SerializeName
 */
public class BootConfig {

  @SerializedName("pluginKey")
  @Nullable
  private String pluginKey;
  @SerializedName("memberId")
  @Nullable
  private String memberId;
  @SerializedName("memberHash")
  @Nullable
  private String memberHash;

  @SerializedName("trackDefaultEvent")
  private boolean trackDefaultEvent;

  @SerializedName("hidePopup")
  private boolean hidePopup;

  @Nullable
  private Profile profile;

  @Nullable
  private Boolean unsubscribed;
  @Nullable
  private Language language;

  @SerializedName("channelButtonOption")
  @Nullable
  private ChannelButtonOption channelButtonOption;

  BootConfig(@Nullable String pluginKey) {
    this.pluginKey = pluginKey;
    this.trackDefaultEvent = Const.DEFAULT_SETTINGS_TRACK_DEFAULT_EVENT;
    this.hidePopup = Const.DEFAULT_SETTINGS_HIDE_POPUP;
  }

  public static BootConfig create(@Nullable String pluginKey) {
    return new BootConfig(pluginKey);
  }

  @Nullable
  public String getPluginKey() {
    return pluginKey;
  }

  @Nullable
  public String getMemberId() {
    return memberId;
  }

  public BootConfig setMemberId(@Nullable String memberId) {
    this.memberId = memberId;
    return this;
  }

  @Nullable
  public String getMemberHash() {
    return memberHash;
  }

  public BootConfig setMemberHash(@Nullable String memberHash) {
    this.memberHash = memberHash;
    return this;
  }

  public boolean isTrackDefaultEvent() {
    return trackDefaultEvent;
  }

  public BootConfig setTrackDefaultEvent(Boolean trackDefaultEvent) {
    if (trackDefaultEvent != null) {
      this.trackDefaultEvent = trackDefaultEvent;
    }
    return this;
  }

  public boolean isHidePopup() {
    return hidePopup;
  }

  public BootConfig setHidePopup(Boolean hidePopup) {
    if (hidePopup != null) {
      this.hidePopup = hidePopup;
    }
    return this;
  }

  @Nullable
  public String getProfile() {
    if (profile != null) {
      return profile.toJson();
    }
    return null;
  }

  public BootConfig setProfile(@Nullable Profile profile) {
    this.profile = profile;
    return this;
  }

  @Nullable
  public Boolean getUnsubscribed() {
    return unsubscribed;
  }

  public BootConfig setUnsubscribed(@Nullable Boolean unsubscribed) {
    this.unsubscribed = unsubscribed;
    return this;
  }

  @NonNull
  public Language getLanguage() {
    if (language != null) {
      return language;
    }
    return Language.getDeviceLanguage();
  }

  public BootConfig setLanguage(@Nullable Language language) {
    this.language = language;
    return this;
  }

  @Nullable
  public ChannelButtonOption getChannelButtonOption() {
    return channelButtonOption;
  }

  public BootConfig setChannelButtonOption(@Nullable ChannelButtonOption channelButtonOption) {
    this.channelButtonOption = channelButtonOption;
    return this;
  }

  // serialize / deserialize

  private static Gson gson = new GsonBuilder().setExclusionStrategies(new GuestExclusionStrategy()).create();

  @Nullable
  public static BootConfig fromJson(@Nullable String json) {
    if (json != null) {
      try {
        return gson.fromJson(json, BootConfig.class);
      } catch (Exception ex) {
      }
    }
    return null;
  }

  @Nullable
  public String toJson() {
    try {
      return gson.toJson(this);
    } catch (Exception ex) {
    }
    return null;
  }

  // Legacy converter

  @Nullable
  @Deprecated
  public static BootConfig fromLegacy(@Nullable ChannelPluginSettings settings, @Nullable com.zoyi.channel.plugin.android.Profile profile) {
    if (settings != null) {
      return BootConfig.create(settings.getPluginKey())
          .setMemberId(settings.getMemberId())
          .setMemberHash(settings.getMemberHash())
          .setTrackDefaultEvent(settings.isEnabledTrackDefaultEvent())
          .setHidePopup(settings.isHideDefaultInAppPush())
          .setProfile(Profile.fromLegacy(profile))
          .setUnsubscribed(settings.getUnsubscribed())
          .setLanguage(Language.fromLegacy(settings.getLocale()))
          .setChannelButtonOption(ChannelButtonOption.fromLegacy(settings.getLauncherConfig()));
    }
    return null;
  }

  private static class GuestExclusionStrategy implements ExclusionStrategy {

    @Override
    public boolean shouldSkipField(FieldAttributes fieldAttributes) {
      return fieldAttributes.getAnnotation(SerializedName.class) == null;
    }

    @Override
    public boolean shouldSkipClass(Class<?> aClass) {
      return false;
    }
  }
}
