package com.zoyi.channel.plugin.android.model.rest.media.instagram;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.com.google.gson.annotations.SerializedName;

import java.util.List;

public class InstagramData implements InstagramMediaEntity {

  @SerializedName("id")
  private String id;

  @SerializedName("mediaType")
  @Nullable
  private String mediaType;

  @SerializedName("username")
  @Nullable
  private String username;

  @SerializedName("commentsCount")
  @Nullable
  private Long commentsCount;

  @SerializedName("likeCount")
  @Nullable
  private Long likeCount;

  @SerializedName("permalink")
  @Nullable
  private String permalink;

  @SerializedName("mediaUrl")
  @Nullable
  private String mediaUrl;

  @SerializedName("thumbnailUrl")
  @Nullable
  private String thumbnailUrl;

  @SerializedName("children")
  private InstagramChildren children;

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getMediaType() {
    if (mediaType != null) {
      return mediaType;
    }
    return "";
  }

  @Nullable
  public String getUsername() {
    return username;
  }

  public long getCommentsCount() {
    if (commentsCount != null) {
      return commentsCount;
    }
    return 0L;
  }

  public long getLikeCount() {
    if (likeCount != null) {
      return likeCount;
    }
    return 0L;
  }

  @Nullable
  public String getPermalink() {
    return permalink;
  }

  @Nullable
  @Override
  public String getMediaUrl() {
    return mediaUrl;
  }

  @Nullable
  @Override
  public String getThumbnailUrl() {
    return thumbnailUrl;
  }

  public List<InstagramMediaEntity> getData() {
    if (children != null) {
      return children.getData();
    }
    return ListUtils.newArrayList(this);
  }
}
