package com.zoyi.channel.plugin.android.activity.lounge.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.*;
import com.zoyi.channel.plugin.android.util.Initializer;

public class LoungeErrorCardView extends FrameLayout implements ErrorRefreshContentView {

    ErrorRefreshView errorRefreshView;

    public LoungeErrorCardView(Context context) {
        super(context);
        init(context);
    }

    public LoungeErrorCardView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public LoungeErrorCardView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    @Initializer
    private void init(Context context) {
        View root = LayoutInflater.from(context).inflate(R.layout.ch_view_lounge_error_card, this, true);

        errorRefreshView = root.findViewById(R.id.ch_viewLoungeErrorCardRefreshView);
    }

    @Override
    public void setOnErrorRefreshClickListener(@Nullable OnErrorRefreshClickListener listener) {
        errorRefreshView.setOnErrorRefreshClickListener(listener);
    }
}
