package com.zoyi.channel.plugin.android.activity.lounge.contract;

import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.entity.LoungeMedia;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;

import java.util.List;

public interface LoungeContract {

  interface View extends BaseView {

    void onDefaultProfileChange(ProfileEntity profileEntity);

    void onWelcomeMessageChange(String plainText);

    void onPreviewStateChange(PreviewState previewState);

    void handleWatermarkVisibility();

    void deactivateWatermark();

    void onLoungeMediaStateChange(String type, FetchState fetchState);

    void onFetchLoungeMediaInstagram(List<LoungeMedia> loungeMedia);
  }

  interface Presenter extends BaseAdapterPresenter {

    void fetchBundleData();

    void fetchPreviewData();

    void removeChat(ChatItem item);

    void fetchConnect(String appMessengerName);

    void fetchLoungeMediaData(String type);
  }
}
