package com.zoyi.channel.plugin.android.activity.common.watermark;

import java.util.HashSet;
import java.util.Set;

public class WatermarkCounter {
  private Set<String> keys;
  private int goalCount;

  private OnWatermarkCounterCompleteListener listener;

  public WatermarkCounter(OnWatermarkCounterCompleteListener listener) {
    this.keys = new HashSet<String>();
    this.listener = listener;
  }

  // call when lounge api fetch start
  public void reset() {
    this.keys.clear();
    this.goalCount = -1;
  }

  // call when lounge api complete, goal count is count of media types
  public void active(int goalCount) {
    this.keys.clear();
    this.goalCount = goalCount;

    if (isComplete()) {
      listener.onComplete();
    }
  }

  public void next(String key) {
    if (!this.keys.contains(key)) {
      this.keys.add(key);

      if (isComplete()) {
        listener.onComplete();
      }
    }
  }

  public boolean isComplete() {
    return this.keys.size() == goalCount;
  }
}
