package com.zoyi.channel.plugin.android.activity.common.error;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.RefreshButton;

public class ErrorRefreshView extends LinearLayout implements ErrorRefreshContentView {

  private RefreshButton buttonErrorRefresh;

  @Nullable
  private OnErrorRefreshClickListener listener;

  public ErrorRefreshView(Context context) {
    super(context);
    init(context);
  }

  public ErrorRefreshView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ErrorRefreshView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_error_refresh, this, true);

    buttonErrorRefresh = root.findViewById(R.id.ch_buttonErrorRefresh);
    buttonErrorRefresh.setOnClickListener(v -> {
      if (listener != null) {
        listener.onRefreshClick();
      }
    });
  }

  @Override
  public void setOnErrorRefreshClickListener(@Nullable OnErrorRefreshClickListener listener) {
    this.listener = listener;
  }
}
