package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.selector.BotSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2018. 11. 5..
 */

public abstract class InitMessageItem implements MessageItem {

  @NonNull
  private long createdAt;

  @Nullable
  private PersonEntity defaultBot;

  InitMessageItem() {
    this(null);
  }

  InitMessageItem(@Nullable Bot bot) {
    this.createdAt = TimeUtils.getCurrentTime();
    this.defaultBot = bot != null ? bot : BotSelector.getDefaultBot();
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt;
  }

  public long getCreatedAt() {
    return createdAt;
  }

  @Nullable
  public PersonEntity getDefaultBot() {
    return defaultBot;
  }
}
