package com.zoyi.channel.plugin.android.activity.chat.binder;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.*;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.Binder2;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.rx.functions.Action1;

public class ChatInteractionBinder extends Binder {
  @Nullable
  private UserChat userChat;

  @Nullable
  private Message marketingMessage;

  private boolean isTyping;

  private boolean temporaryInputOpened = false;

  private StoreBinder binder;

  public ChatInteractionBinder(@Nullable Message marketingMessage, Action1<ChatInteractionState> action1) {
    // recent message is not null when new chat created
    this.marketingMessage = marketingMessage;

    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;

    this.binder = new Binder2<>(channelState, nowState).bind((channel, now) -> {
      if (this.userChat != null) {
        if (this.temporaryInputOpened && !Const.USER_CHAT_STATE_SOLVED.equals(this.userChat.getState())) {
          this.temporaryInputOpened = false;
        }

        boolean acceptInput = ChannelSelector.shouldAcceptAction(channel, now, this.isTyping);

        if (this.marketingMessage != null
            && this.marketingMessage.getMarketing() != null
            && this.marketingMessage.getMarketing().getEnableSupportBot()
            && this.userChat.getState() == null
            && !this.userChat.isSupporting()
        ) {
          action1.call(ChatInteractionState.MARKETING_SUPPORT_BOT);
        } else if (this.userChat.isSupporting()) {
          action1.call(ChatInteractionState.NONE);
        } else if (this.userChat.isStateClosed()) {
          action1.call(ChatInteractionState.NEW_CHAT_START);
        } else if (this.userChat.isStateSolved()) {
          if (this.temporaryInputOpened) {
            action1.call(acceptInput ? ChatInteractionState.NORMAL : ChatInteractionState.DISABLE);
          } else {
            action1.call(ChatInteractionState.NONE);
          }
        } else {
          action1.call(acceptInput ? ChatInteractionState.NORMAL : ChatInteractionState.DISABLE);
        }
      }
    });
  }

  public void setUserChat(@Nullable UserChat userChat) {
    this.userChat = userChat;

    this.binder.revoke();
  }

  @Nullable
  public Message getMarketingMessage() {
    return marketingMessage;
  }

  public void setMarketingMessage(@Nullable Message message) {
    if (this.marketingMessage == null && message == null) {
      return;
    }

    if (message != null && message.getMarketing() != null) {
      this.marketingMessage = message;
      this.binder.revoke();
    } else if (this.marketingMessage != null) {
      this.marketingMessage = null;
      this.binder.revoke();
    }
  }

  public void setTyping(boolean isTyping) {
    this.isTyping = isTyping;

    this.binder.revoke();
  }

  public void setTemporaryInputOpened(boolean temporaryInputOpened) {
    this.temporaryInputOpened = temporaryInputOpened;

    this.binder.revoke();
  }

  @Override
  public void unbind() {
    this.binder.unbind();
  }

  @Override
  public ChatInteractionBinder bind(BinderController controller) {
    super.bind(controller);

    return this;
  }
}
