package com.zoyi.channel.plugin.android.action;

import android.app.Activity;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.*;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;

import java.util.HashMap;
import java.util.Map;

public class EventAction {

  public static void trackPageView() {
    Map<String, Object> property = new HashMap<>();
    Activity activity = GlobalStore.get().topActivity.get();

    if (activity != null && !ChannelUtils.isChannelPluginActivity(activity)) {
      property.put(Const.PROPERTY_URL, activity.getClass().getSimpleName());
    }

    track(new Event(Const.PAGE_VIEW_EVENT_NAME, property));
  }

  public static void track(Event event) {
    String pluginId = PrefSupervisor.getLatestBootedPluginId(ChannelIO.getAppContext());
    String jwt = PrefSupervisor.getJwt(ChannelIO.getAppContext());

    if (pluginId != null && jwt != null) {
      Api.trackEvent(pluginId, event.getName(), event.getPropertyToJson(), jwt).run();
    }
  }
}
