/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParser;
import java.util.LinkedList;
import java.util.List;

public class MessageParserUtils {
    public static BlockParseResult parseBlocks(@Nullable List<Block> blocks) {
        return MessageParserUtils.parseBlocks(blocks, MessageParserUtils.getDefaultParseOption(), null);
    }

    public static BlockParseResult parseBlocks(@Nullable List<Block> blocks, MessageParseOptions options) {
        return MessageParserUtils.parseBlocks(blocks, options, null);
    }

    public static BlockParseResult parseBlocks(@Nullable List<Block> blocks, MessageParseOptions options, @Nullable Marketing marketing) {
        BlockParseResult blockParseResult = new BlockParseResult();
        if (blocks == null) {
            return blockParseResult;
        }
        boolean showGiantEmoji = blocks.size() == 1;
        LinkedList<Block> blockQueue = new LinkedList<Block>(blocks);
        while (blockQueue.size() != 0) {
            Block block = (Block)blockQueue.poll();
            String type = block.getType();
            try {
                if (type != null && block.getValue() != null && !block.getValue().isEmpty()) {
                    switch (type) {
                        case "text": {
                            BlockParseResult result = MessageParserUtils.parseTextBlock(options, marketing, block);
                            if (result != null) {
                                block.setFormattedSpanMessage(result.getPlainTextBuilder());
                                block.setHasOnlyEmoji(result.hasOnlyEmoji() && showGiantEmoji);
                                blockParseResult.append(result);
                                break;
                            }
                            block.setFormattedSpanMessage(new SpannableStringBuilder((CharSequence)block.getValue()));
                            block.setHasOnlyEmoji(false);
                            blockParseResult.append(block.getValue());
                            break;
                        }
                        case "code": {
                            block.setFormattedSpanMessage(new SpannableStringBuilder((CharSequence)block.getValue()));
                            blockParseResult.append(block.getValue());
                        }
                    }
                    continue;
                }
                if (block.getBlocks() == null || block.getBlocks().isEmpty()) continue;
                blockQueue.addAll(block.getBlocks());
            }
            catch (Exception exception) {}
        }
        return blockParseResult;
    }

    public static SpannableStringBuilder parseText(@Nullable String parseText) {
        return MessageParserUtils.parseText(parseText, MessageParserUtils.getDefaultParseOption());
    }

    public static SpannableStringBuilder parseText(@Nullable String parseText, MessageParseOptions options) {
        if (parseText == null) {
            return new SpannableStringBuilder();
        }
        return new MessageParser(options).parse(parseText).getPlainTextBuilder();
    }

    private static MessageParseOptions getDefaultParseOption() {
        return MessageParseOptions.MessageParseOptionsBuilder.create().withEnableVariable(false).build();
    }

    @Nullable
    private static BlockParseResult parseTextBlock(MessageParseOptions options, @Nullable Marketing marketing, Block block) {
        try {
            return new MessageParser(options, marketing).parse(block.getValue());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

