/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.enumerate;

import com.zoyi.channel.plugin.android.util.ResUtils;

public enum DayOfWeekType {
    MON(0, "mon", "ch.out_of_work.mon"),
    TUE(1, "tue", "ch.out_of_work.tue"),
    WED(2, "wed", "ch.out_of_work.wed"),
    THU(3, "thu", "ch.out_of_work.thu"),
    FRI(4, "fri", "ch.out_of_work.fri"),
    SAT(5, "sat", "ch.out_of_work.sat"),
    SUN(6, "sun", "ch.out_of_work.sun"),
    UNKNOWN(7, "", "ch.unknown");

    private int index;
    private String value;
    private String translationKey;

    private DayOfWeekType(int index, String value, String translationKey) {
        this.index = index;
        this.value = value;
        this.translationKey = translationKey;
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.value;
    }

    public static DayOfWeekType fromString(String dayOfWeek) {
        switch (dayOfWeek) {
            case "mon": {
                return MON;
            }
            case "tue": {
                return TUE;
            }
            case "wed": {
                return WED;
            }
            case "thu": {
                return THU;
            }
            case "fri": {
                return FRI;
            }
            case "sat": {
                return SAT;
            }
            case "sun": {
                return SUN;
            }
        }
        return UNKNOWN;
    }

    public String getString() {
        return ResUtils.getString(this.translationKey);
    }
}

