/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.app.Dialog;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.AbsUserMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.com.annimon.stream.Optional;
import java.util.List;

public class UserMessageHolder
extends AbsUserMessageHolder {
    @Nullable
    private OnMessageActionListener listener;
    @Nullable
    private Message message;

    private UserMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
        super(itemView, listener);
        this.listener = listener;
    }

    public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail) {
        super.bind(item.getCreatedAt(), showDate, isHead, isTail);
        this.message = item.getMessage();
        String messageId = (String)Optional.ofNullable((Object)item.getMessage()).map(Message::getId).orElse(null);
        if (item.getMessage() != null) {
            if (item.getMessage().isDeleted()) {
                this.setDeleteMessage();
            } else {
                if (item.getMessage() != null && item.getMessage().getBlocks() != null) {
                    this.setBlocks(item.getMessage().getBlocks());
                }
                Optional.ofNullable((Object)item.getMessage()).map(Message::getWebPage).ifPresent(webPage -> this.setWebPage(messageId, (WebPage)webPage));
                this.setAttachments((String)Optional.ofNullable((Object)item.getMessage()).map(Message::getId).orElse(null), item.getMessage().getFiles(), this);
                this.setReactions(item.getMessage().getReactions());
            }
        }
    }

    @Override
    protected void setText(@Nullable CharSequence text) {
        super.setText(text);
        if (this.textMessage != null) {
            this.textMessage.setAlpha(1.0f);
        }
    }

    @Override
    protected void setBlocks(@Nullable List<Block> blocks) {
        super.setBlocks(blocks);
        if (this.textMessage != null) {
            this.textMessage.setAlpha(1.0f);
        }
    }

    @Override
    protected void setLinkButtons(@Nullable List<Button> buttons) {
        super.setLinkButtons(buttons);
        if (this.textMessage != null) {
            this.textMessage.setAlpha(1.0f);
        }
    }

    @Override
    protected void setDeleteMessage() {
        super.setDeleteMessage();
        if (this.textMessage != null) {
            this.textMessage.setAlpha(0.5f);
        }
    }

    @Override
    public boolean onLongClick(View v) {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
            return true;
        }
        return false;
    }

    @Override
    public void onWebPageLongClick() {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
        }
    }

    @Override
    protected void onReactionsLongClicked() {
        if (this.listener != null && this.message != null && this.message.getReactions() != null && this.message.getReactions().size() > 0) {
            this.listener.onReactionsLongClicked(this.message.getReactions());
        }
    }

    @Override
    public void onAttachmentClick(File attachment) {
        super.onAttachmentClick(attachment);
        if (this.listener != null && this.message != null) {
            this.listener.onAttachmentClick(attachment, this.message);
        }
    }

    @Override
    public void onAttachmentLongClick() {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
        }
    }

    @Override
    public void onLinkButtonLongClick() {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
        }
    }

    public static UserMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
        return new UserMessageHolder(UserMessageHolder.getItemView(parent), listener);
    }

    @Override
    protected void onRecycled() {
        super.onRecycled();
        this.message = null;
    }
}

