/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.ChatPresenter;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatContract;
import com.zoyi.channel.plugin.android.activity.chat.dialog.ReactionsDialog;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChatActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.utils.KeyboardUtils;
import com.zoyi.channel.plugin.android.activity.chat.view.chat.ChatInputView;
import com.zoyi.channel.plugin.android.activity.chat.view.chat.NewMessageAlertView;
import com.zoyi.channel.plugin.android.activity.chat.view.navigation.HostHeaderView;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.navigation.ChannelInfoNavigationView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.ChatInputType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.ChatStore;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.store.TypingStore;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.IconButtonBottomSheetDialog;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.scrollview.RecyclerBottomPlaceholderLayout;
import com.zoyi.channel.plugin.android.view.toast.DateToastView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ChatActivity
extends BaseActivity2
implements ChatContract.View,
OnMessageContentClickListener,
MessageActionListener,
OnProfileUpdateRequestListener,
OnChatActionListener {
    private NavigationView navigation;
    private ChannelInfoNavigationView channelHeader;
    private HostHeaderView hostHeader;
    private View layoutContent;
    private View layoutProgress;
    private ErrorRefreshView layoutError;
    private ChatInputView inputView;
    private RecyclerView recyclerView;
    private NewMessageAlertView newMessageAlertView;
    private DateToastView dateToastView;
    private RecyclerBottomPlaceholderLayout bottomPlaceholder;
    private ChatStartButton buttonNewChat;
    private ChatAdapter adapter;
    private LinearLayoutManager layoutManager;
    private ChatContract.Presenter presenter;
    @Nullable
    private KeyboardUtils keyboardUtils;
    @Nullable
    private Subscription toastSubscription;
    private PublishSubject<Integer> toastPublishSubject = PublishSubject.create();

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_chat);
        Intent intent = this.getIntent();
        ChatContentType contentType = ChatContentType.NONE;
        String contentId = null;
        String presetMessage = null;
        if (intent != null) {
            contentType = ChatContentType.fromString(intent.getStringExtra("chatContentType"));
            contentId = intent.getStringExtra("chatContentId");
            presetMessage = intent.getStringExtra("chatPresetMessage");
        }
        this.navigation = (NavigationView)this.findViewById(R.id.ch_navigationChat);
        this.navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));
        this.channelHeader = (ChannelInfoNavigationView)this.findViewById(R.id.ch_navigationChatChannel);
        this.hostHeader = (HostHeaderView)this.findViewById(R.id.ch_navigationChatHost);
        this.hostHeader.setVisibility(8);
        this.layoutContent = this.findViewById(R.id.ch_layoutChatContent);
        this.layoutProgress = this.findViewById(R.id.ch_layoutChatProgress);
        this.layoutError = (ErrorRefreshView)this.findViewById(R.id.ch_layoutChatError);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.ch_recyclerViewChat);
        this.newMessageAlertView = (NewMessageAlertView)this.findViewById(R.id.ch_viewNewMessageAlert);
        this.newMessageAlertView.setListener(() -> {
            this.scrollToBottom();
            this.newMessageAlertView.hide();
        });
        this.dateToastView = (DateToastView)this.findViewById(R.id.ch_viewChatDateToast);
        this.inputView = (ChatInputView)this.findViewById(R.id.ch_viewChatInput);
        this.inputView.setMessageActionListener(this);
        this.inputView.setStartSupportBotClickListener(view -> this.presenter.onCreateSupportBotClick());
        this.adapter = new ChatAdapter(this);
        this.adapter.setOnMessageContentClickListener(this);
        this.adapter.setOnProfileUpdateRequestListener(this);
        this.presenter = new ChatPresenter(this, this.adapter, this.adapter, contentType, contentId, presetMessage);
        this.layoutManager = new LinearLayoutManager((Context)this){

            public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
                return false;
            }
        };
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerView.setItemAnimator(null);
        this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(){

            @Override
            public void scrollAttachedToBottom() {
                ChatActivity.this.newMessageAlertView.hide();
            }

            @Override
            public void scrollAttachedToTop() {
                ChatActivity.this.presenter.fetchBackwardMessages();
            }
        });
        this.bottomPlaceholder = (RecyclerBottomPlaceholderLayout)this.findViewById(R.id.ch_bottomLayoutChat);
        this.bottomPlaceholder.setRecyclerView(this.recyclerView);
        this.bottomPlaceholder.setStackFromEnd(true);
        this.bottomPlaceholder.setOnSizeChangeListener(height -> {
            ViewGroup.LayoutParams params = this.newMessageAlertView.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)params).setMargins(0, 0, 0, height);
            }
        });
        this.buttonNewChat = (ChatStartButton)this.findViewById(R.id.ch_buttonChatStartNewChat);
        this.buttonNewChat.setOnClickListener(v -> this.finish(22, Transition.NONE));
        this.keyboardUtils = new KeyboardUtils(this, this.layoutContent, this.recyclerView);
        this.keyboardUtils.enable();
        this.toastSubscription = this.toastPublishSubject.throttleLast(250L, TimeUnit.MILLISECONDS).onBackpressureLatest().observeOn(AndroidSchedulers.mainThread()).subscribe(integer2 -> this.showFirstMessageDate(this.adapter.getItem((int)integer2)));
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                if (dy != 0 && ChatActivity.this.toastPublishSubject != null && recyclerView.getLayoutManager() != null) {
                    ChatActivity.this.toastPublishSubject.onNext((Object)((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition());
                }
            }
        });
        this.bindPresenter(this.presenter);
        GlobalStore.get().activeChatActivity.set(this);
        return true;
    }

    protected void onPause() {
        super.onPause();
        KeyboardUtils.hideKeyboard((Activity)this);
        if (this.isFinishing()) {
            this.recyclerView.setAdapter(null);
            ChatStore.get().reset();
            TranslationStore.get().reset();
            ProfileBotStore.get().reset();
            TypingStore.get().reset();
            ChatActivity chatActivity = GlobalStore.get().activeChatActivity.get();
            if (this == chatActivity) {
                GlobalStore.get().activeChatActivity.set(null);
            }
            Action.invoke(ActionType.CHAT_CLOSED);
        }
    }

    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        if (this.keyboardUtils != null) {
            this.keyboardUtils.disable();
        }
        if (this.toastSubscription != null && !this.toastSubscription.isUnsubscribed()) {
            this.toastSubscription.unsubscribe();
        }
        this.keyboardUtils = null;
        this.toastSubscription = null;
        super.onDestroy();
    }

    @Override
    public void onFetchStateChange(FetchState fetchState) {
        this.layoutContent.setVisibility(8);
        this.layoutProgress.setVisibility(8);
        this.layoutError.setVisibility(8);
        switch (fetchState) {
            case LOADING: {
                this.layoutProgress.setVisibility(0);
                break;
            }
            case FAILED: {
                this.layoutError.setVisibility(0);
                break;
            }
            case COMPLETE: {
                this.layoutContent.setVisibility(0);
            }
        }
    }

    @Override
    public void onWelcomeStateChange(ChatContentType contentType, boolean acceptInput) {
        this.channelHeader.setVisibility(0);
        this.hostHeader.setVisibility(8);
        this.buttonNewChat.setVisibility(8);
        switch (contentType) {
            case NONE: {
                this.inputView.setVisibility(0);
                this.inputView.setState(acceptInput ? ChatInputType.NORMAL : ChatInputType.DISABLE);
                break;
            }
            case SUPPORT_BOT_CHAT: {
                this.inputView.setVisibility(8);
            }
        }
    }

    @Override
    public void onChatStateChange(UserChat userChat, Message recentMessage, boolean acceptInput, boolean temporaryInputOpened, boolean isWorking) {
        if (userChat.isStateRemoved()) {
            this.finish(Transition.NONE);
            return;
        }
        this.inputView.initUserChat(userChat.getId());
        if (userChat.getAssigneeId() != null && isWorking) {
            this.channelHeader.setVisibility(8);
            this.hostHeader.setVisibility(0);
            this.hostHeader.attachUserChat(userChat.getId());
        } else {
            this.channelHeader.setVisibility(0);
            this.hostHeader.setVisibility(8);
        }
        if (recentMessage != null && recentMessage.getMarketing() != null && recentMessage.getMarketing().getEnableSupportBot() && userChat.getState() == null && !userChat.isSupporting() && SupportBotStore.get().supportBotState.get() != null) {
            Keyboard.close((Context)this, (View)this.inputView.getEditText());
            this.inputView.setState(ChatInputType.MARKETING_SUPPORT);
            this.buttonNewChat.setVisibility(8);
        } else if (userChat.isSupporting()) {
            Keyboard.close((Context)this, (View)this.inputView.getEditText());
            this.inputView.setVisibility(8);
            this.buttonNewChat.setVisibility(8);
        } else if (userChat.isStateClosed()) {
            Keyboard.close((Context)this, (View)this.inputView.getEditText());
            this.inputView.setVisibility(8);
            this.buttonNewChat.setVisibility(0);
        } else if (userChat.isStateSolved()) {
            if (temporaryInputOpened) {
                this.inputView.setVisibility(0);
                this.inputView.setState(acceptInput ? ChatInputType.NORMAL : ChatInputType.DISABLE);
                this.buttonNewChat.setVisibility(8);
            } else {
                Keyboard.close((Context)this, (View)this.inputView.getEditText());
                this.inputView.setVisibility(8);
                this.buttonNewChat.setVisibility(8);
            }
        } else {
            this.inputView.setVisibility(0);
            this.inputView.setState(acceptInput ? ChatInputType.NORMAL : ChatInputType.DISABLE);
            this.buttonNewChat.setVisibility(8);
        }
    }

    @Override
    public boolean isScrollable() {
        return this.recyclerView.canScrollVertically(1) || this.recyclerView.canScrollVertically(-1);
    }

    @Override
    public boolean isScrollOnBottom() {
        return !this.recyclerView.canScrollVertically(1);
    }

    @Override
    public void scrollToBottom() {
        this.layoutManager.scrollToPosition(this.adapter.getItemCount() - 1);
    }

    @Override
    public void showNewMessageAlert(ProfileEntity profileEntity) {
        this.newMessageAlertView.show(profileEntity);
    }

    @Override
    @Nullable
    public Dialog onMessageLongClick(Message message) {
        IconButtonBottomSheetDialog dialog = new IconButtonBottomSheetDialog((Context)this);
        if (message != null) {
            if (!message.getPlainText().isEmpty()) {
                dialog.addButton(R.drawable.ch_copy, ResUtils.getString("ch.chat.message.actions.copy_message"), () -> this.copyText(message.getPlainText()));
            }
            if (!message.isDeleted() && message.getPersonType() != null && message.getPersonType().equals("user") && message.getChatId() != null && message.getId() != null && message.getLog() == null) {
                dialog.addButton(R.drawable.ch_trash, ResUtils.getString("ch.chat.message.actions.delete_message"), R.color.ch_red400, R.color.ch_red400, () -> this.showDeleteMessageConfirmDialog(message.getChatId(), message.getId()));
            }
            if (dialog.getButtons().size() > 0) {
                return dialog;
            }
        }
        return null;
    }

    @Override
    public void onOpenVideoClick(File attachment, long startAt) {
        Executor.startFullScreenVideo((Context)this, attachment, startAt);
    }

    @Override
    public void onAttachmentClick(File attachment, Message message) {
        if (attachment.isImage()) {
            IntentUtils.setNextActivity((Context)this, PhotoAlbumActivity.class).putExtra("attachementId", attachment.getId()).putExtra("storageId", PhotoAlbumStorage.getInstance().save(message.getFiles())).startActivityForResult(3001);
        } else {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", attachment.getUrl()).putExtra("filename", attachment.getName()).putExtra("EXTRA_TYPE", attachment.getType()).setTransition(Transition.NONE).startActivity();
        }
    }

    @Override
    public void onUrlClick(String url) {
        Executor.executeLinkAction((Context)this, url, LinkType.URL);
    }

    @Override
    public void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton) {
        this.presenter.onActionClick(actionType, actionButton);
    }

    @Override
    public void onResendButtonClick(SendItem sendItem) {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)ResUtils.getString("ch.chat.resend.description")).setPositiveButton((CharSequence)ResUtils.getString("ch.chat.retry_sending_message"), (dialog12, which) -> this.presenter.resend(sendItem)).setNegativeButton((CharSequence)ResUtils.getString("ch.chat.resend.cancel"), null).setNeutralButton((CharSequence)ResUtils.getString("ch.chat.delete"), (dialog1, which) -> this.presenter.removeFailedItem(sendItem)).setCancelable(true).create();
        dialog.setOnShowListener(args -> {
            int dark = ContextCompat.getColor((Context)this, (int)R.color.ch_grey900);
            int cobalt = ContextCompat.getColor((Context)this, (int)R.color.ch_cobalt400);
            dialog.getButton(-1).setTextColor(cobalt);
            dialog.getButton(-2).setTextColor(dark);
            dialog.getButton(-3).setTextColor(dark);
        });
        dialog.show();
    }

    @Override
    public void onCancelClick(@Nullable SendFileItem sendFileItem) {
        if (sendFileItem != null) {
            this.presenter.cancelSendingFile(sendFileItem);
        }
    }

    @Override
    public void onAttachmentButtonClick() {
        IntentUtils.setNextActivity((Context)this, PhotoPickerActivity.class).startActivityForResult(902);
    }

    @Override
    public void onSendClick(String message) {
        this.presenter.sendText(message);
    }

    @Override
    public void onMarketingAction(Marketing marketing, @Nullable String url) {
        MarketingAction.sendClickEvent(marketing, url);
    }

    @Override
    public void onReactionsLongClicked(List<Reaction> reactions) {
        new ReactionsDialog((Context)this, reactions).show();
    }

    @Override
    public void onProfileRequest(ProfileBotMessageItem item, String key, @Nullable Object value) {
        this.presenter.updateProfile(item, key, value);
    }

    @Override
    public void onProfileUpdateComplete() {
        this.inputView.setFocus();
    }

    @Override
    public void setInputDim(boolean enabled) {
        this.inputView.setInputDim(enabled);
    }

    @Override
    public void setTextInput(@Nullable String message) {
        if (message != null) {
            this.inputView.getEditText().setText((CharSequence)message);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 902: {
                if (resultCode != 12) break;
                this.presenter.uploadFiles(data.getParcelableArrayListExtra("PHOTO_INTENT_KEY"));
            }
        }
    }

    private void copyText(String text) {
        if (ClipboardUtils.copyToClipBoard(text)) {
            Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.copy_message.success"), (int)0).show();
        }
    }

    private void showFirstMessageDate(@Nullable MessageItem item) {
        if (item != null && this.dateToastView != null) {
            switch (item.getType()) {
                case HOST: 
                case USER: {
                    ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                    if (chatMessageItem.getCreatedAt() == 0L) break;
                    this.dateToastView.show(chatMessageItem.getCreatedAt());
                }
            }
        }
    }

    private void showDeleteMessageConfirmDialog(String userChatId, String messageId) {
        ((ChannelDialog)((Object)((ChannelDialog)((Object)((ChannelDialog)((Object)new ChannelDialog((Context)this).setTitle(ResUtils.getString("ch.chat.message.delete_confirm.title")))).setDescription(ResUtils.getString("ch.chat.message.delete_confirm.message")).addButton(ButtonType.CANCEL))).addButton(ResUtils.getString("ch.chat.delete"), ResUtils.getColor(R.color.ch_red400), v -> this.presenter.deleteMessage(userChatId, messageId)))).show();
    }
}

