package com.zoyi.channel.plugin.android.view.youtube.player;


import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;

/**
 * Use this interface to control the playback of YouTube videos and to listen to their events.
 */
public interface YouTubePlayer {

  /**
   * Loads and automatically plays the video.
   *
   * @param videoId      id of the video
   * @param startSeconds the time from which the video should start playing
   */
  void loadVideo(@Nullable String videoId, float startSeconds);

  /**
   * Loads the video's thumbnail and prepares the player to play the video. Does not automatically play the video.
   *
   * @param videoId      id of the video
   * @param startSeconds the time from which the video should start playing
   */
  void cueVideo(@Nullable String videoId, float startSeconds);

  void play();

  void pause();

  void mute();

  void unMute();

  /**
   * @param volumePercent Integer between 0 and 100
   */
  void setVolume(int volumePercent);

  /**
   * @param time The absolute time in seconds to seek to
   */
  void seekTo(float time);

  boolean addListener(YouTubePlayerListener listener);

  boolean removeListener(YouTubePlayerListener listener);
}
