package com.zoyi.channel.plugin.android.view.load_wrapper;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.*;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;

import java.util.List;

public class LoadWrapperLayout extends FrameLayout {

  private List<Integer> componentIds = ListUtils.newArrayList(
      R.id.ch_rootLoadWrapper,
      R.id.ch_layoutLoadWrapperContent,
      R.id.ch_progressLoadWrapper,
      R.id.ch_errorLoadWrapper
  );

  @Nullable
  private FrameLayout layoutLoadWrapperContent;

  @Nullable
  private CircularProgressView progressLoadWrapper;

  @Nullable
  private ErrorRefreshView errorLoadWrapper;

  public LoadWrapperLayout(@NonNull Context context) {
    super(context);
    init(context);
  }

  public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public LoadWrapperLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_load_wrapper, this);

    layoutLoadWrapperContent = findViewById(R.id.ch_layoutLoadWrapperContent);
    progressLoadWrapper = findViewById(R.id.ch_progressLoadWrapper);
    errorLoadWrapper = findViewById(R.id.ch_errorLoadWrapper);
  }

  public void setLoadState(FetchState fetchState) {
    Views.setVisibility(progressLoadWrapper, fetchState == FetchState.LOADING);
    Views.setVisibility(errorLoadWrapper, fetchState == FetchState.FAILED);
    Views.setVisibility(layoutLoadWrapperContent, fetchState == FetchState.COMPLETE);
  }

  public void setRefreshListener(OnClickListener listener) {
    if (errorLoadWrapper != null) {
      errorLoadWrapper.setListener(listener);
    }
  }

  @Override
  public void addView(View child, int index, ViewGroup.LayoutParams params) {
    if (child != null && componentIds.contains(child.getId())) {
      super.addView(child, index, params);
    } else if (layoutLoadWrapperContent != null && child != null) {
      layoutLoadWrapperContent.addView(child, index, params);
    }
  }
}
