package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.*;
import com.zoyi.channel.plugin.android.store.state.*;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;

import java.util.ArrayList;
import java.util.List;

public class ProfileBotSelector {

  public static Binder bindProfileBotActivation(Action1<Boolean> action1) {
    BooleanState requestFocusState = ProfileBotStore.get().requestFocus;

    return new Binder1<>(requestFocusState).bind(action1);
  }

  public static Binder bindProfileSchemasFetchState(Action1<FetchState> action1) {
    return new Binder1<>(ProfileBotSchemaStore.get().profileBotSchemasFetchState).bind(action1);
  }

  public static Binder bindProfileSchemas(Action2<List<ProfileBotSchema>, User> action2) {
    State<List<ProfileBotSchema>> profileBotSchemasState = ProfileBotSchemaStore.get().profileBotSchemas;
    State<User> userState = UserStore.get().user;
    EnumState<Language> languageState = SettingsStore.get().language;

    return new Binder3<>(profileBotSchemasState, userState, languageState).bind((profileBotSchemas, user, language) -> {
      if (user != null) {
        if (profileBotSchemas == null) {
          action2.call(new ArrayList<>(), user);
        } else {
          action2.call(profileBotSchemas, user);
        }
      }
    });
  }

  @Nullable
  public static ProfileBotSchema getProfileBotSchemaByKey(@Nullable String key) {
    if (key == null) {
      return null;
    }

    List<ProfileBotSchema> profileBotSchemas = ProfileBotSchemaStore.get().profileBotSchemas.get();

    if (profileBotSchemas == null) {
      return null;
    }

    for (ProfileBotSchema profileBotSchema : profileBotSchemas) {
      if (key.equals(profileBotSchema.getKey())) {
        return profileBotSchema;
      }
    }
    return null;
  }
}
