package com.zoyi.channel.plugin.android.network;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.annotation.Success;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.repo.PluginRepo;
import com.zoyi.channel.plugin.android.model.repo.UserRepo;
import com.zoyi.retrofit2.http.*;
import com.zoyi.rx.Observable;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface SimpleChannelApi {

  @Success
  @FormUrlEncoded
  @POST("/front/elastic/plugins/{key}/boot")
  Observable<PluginRepo> boot(
      @Nullable @Header(Const.ACCEPT_LANGUAGE) String acceptLanguage,
      @Nullable @Path("key") String key,
      @Nullable @Field("memberId") String memberId,
      @Nullable @Field("memberHash") String memberHash,
      @Nullable @Field("unsubscribed") Boolean unsubscribed,
      @Nullable @Field("url") String url,
      @Nullable @Field("profile") String profile,
      @Nullable @Field("veilId") String veilId
  );

  @Success
  @FormUrlEncoded
  @POST("/front/elastic/plugins/{id}/touch")
  Observable<UserRepo> touch(@Path("id") String id, @Field("sessionJWT") String sessionJWT);

  @Success
  @FormUrlEncoded
  @POST("/front/elastic/plugins/{pluginId}/events")
  Observable<Void> trackEvent(@Path("pluginId") String pluginId, @Field("name") String name, @Field("property") String property,
      @Field("sessionJWT") String sessionJWT);
}
