package com.zoyi.channel.plugin.android.activity.chat2;

import android.app.Activity;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.bind.BindAction;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.selector.ChatSelector;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.com.annimon.stream.Optional;

public class ChatPresenter2
    extends AbstractAdapterPresenter<ChatContract2.View, ChatAdapterContract.View, ChatAdapterContract.Model>
    implements ChatContract2.Presenter {

  private ChatContentType contentType = ChatContentType.NONE;

  @Nullable
  private String contentId;

  @Nullable
  private String presetMessage;

  public ChatPresenter2(
      ChatContract2.View view,
      ChatAdapterContract.View adapterView,
      ChatAdapterContract.Model adapterModel,
      @Nullable String contentId,
      @Nullable String presetMessage
  ) {
    super(view, adapterView, adapterModel);

    this.contentId = contentId;
    this.presetMessage = presetMessage;
  }

  @Override
  public void init() {
    view.onFetchStateChange(FetchState.LOADING);

    if (contentId != null) {
      contentType = ChatContentType.USER_CHAT;
      bindUserChat();
    } else {
      Plugin plugin = PluginStore.get().pluginState.get();
      if (plugin != null && plugin.getId() != null) {
        setLocalChat();
      }
    }
  }

  // set local chat logic

  private void setLocalChat() {
    Plugin plugin = PluginStore.get().pluginState.get();
    FetchState pluginFetch = PluginStore.get().pluginFetchState.get();

    SupportBotEntry supportBotEntry = SupportBotStore.get().supportBotState.get();
    FetchState supportBotFetch = SupportBotStore.get().supportBotFetchState.get();

    Language language = SettingsStore.get().language.get();

    CharSequence welcomeMessage = MessageUtils.createWelcomeMessage(plugin, language);

    if (presetMessage != null) {
      setLocalMessage(welcomeMessage, null);
    } else if (supportBotFetch == FetchState.COMPLETE && supportBotEntry != null) {
      setLocalMessage(null, supportBotEntry);
    } else if (pluginFetch == FetchState.COMPLETE && plugin != null) {
      setLocalMessage(welcomeMessage, null);
    } else {
      view.finish();
    }
  }

  private void setLocalMessage(@Nullable CharSequence welcomeMessage, @Nullable SupportBotEntry supportBotEntry) {
    if (welcomeMessage != null) {
      this.contentType = ChatContentType.NONE;

      adapterModel.setInitMessage(new WelcomeMessageItem(welcomeMessage));

      view.onLocalMessageLoaded(ChatContentType.NONE, false);

      view.onFetchStateChange(FetchState.COMPLETE);
    } else if (supportBotEntry != null) {
      this.contentType = ChatContentType.SUPPORT_BOT_CHAT;
      this.contentId = supportBotEntry.getId();

      adapterModel.setInitMessage(new SupportBotMessageItem(supportBotEntry));

      view.onLocalMessageLoaded(ChatContentType.SUPPORT_BOT_CHAT, false);
      view.onFetchStateChange(FetchState.COMPLETE);
    }
  }

  @Override
  public void createUserChat() {
    if (!Api.isRunning(ActionType.CREATE_USER_CHAT)) {
      Plugin plugin = PluginStore.get().pluginState.get();
      String pluginId = plugin != null ? plugin.getId() : null;

      Activity topActivity = GlobalStore.get().topActivity.get();
      String url = Optional.ofNullable(topActivity).map(Activity::getClass).map(Class::getSimpleName).orElse("");

      if (pluginId != null) {
        Api.createUserChat2(pluginId, url)
            .onError(error -> view.onFetchStateChange(FetchState.FAILED))
            .call(repo -> {
              ChannelPluginListener listener = ChannelIO.getListener();

              if (listener != null && repo.getUserChat().getId() != null) {
                listener.onChatCreated(repo.getUserChat().getId());
              }

              handleUserChatInit(repo.getUserChat(), repo.getMessage());
            })
            .bind(this, BindAction.CREATE_CHAT);
      }
    }
  }

  // Call when user chat create by user manually

  private void handleUserChatInit(UserChat userChat, Message message) {
    clear();

    if (userChat != null && userChat.getId() != null) {
      this.contentType = ChatContentType.USER_CHAT;
      this.contentId = userChat.getId();

      adapterModel.replaceInitMessageItem(message);

      bindUserChat();
    }
  }










  // user chat logic

  private void bindUserChat() {
    // subscribe only once

    if (contentType == ChatContentType.USER_CHAT && contentId != null) {

      bind(ChatSelector.bindChat(contentId, (userChat, recentMessage, acceptInput, temporaryInputOpened, isWorking) -> {

        // TODO : Add chat action

        view.onChatStateChange(userChat, recentMessage, acceptInput, temporaryInputOpened, isWorking);
      }));
    }
  }
}
