package com.zoyi.channel.plugin.android.activity.chat2;

import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;

public interface ChatContract2 {

  interface View extends BaseView {

    void onFetchStateChange(FetchState fetchState);

    void onLocalMessageLoaded(ChatContentType contentType, boolean acceptInput);

    void onChatStateChange(UserChat userChat, Message message, boolean acceptInput, boolean temporaryInputOpened, boolean isWorking);
  }

  interface Presenter extends BaseAdapterPresenter {

    void createUserChat();
  }
}
