package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

import java.net.URLEncoder;
import java.util.List;

public class ReactionsView extends FrameLayout implements MessageContentView {

  public ReactionsView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public ReactionsView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public ReactionsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;
  private AppCompatImageView reactionView1;
  private AppCompatImageView reactionView2;
  private AppCompatImageView reactionView3;
  private TextView textCount;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_holder_message_content_reactions, this);

    this.context = context;

    reactionView1 = findViewById(R.id.ch_imageMessageReaction1);
    reactionView2 = findViewById(R.id.ch_imageMessageReaction2);
    reactionView3 = findViewById(R.id.ch_imageMessageReaction3);
    textCount = findViewById(R.id.ch_textMessageReactionsCount);
  }

  public void setReactions(@NonNull List<Reaction> reactions) {
    setReactionEmoji(reactionView1, reactions.size() >= 1 ? reactions.get(0) : null);
    setReactionEmoji(reactionView2, reactions.size() >= 2 ? reactions.get(1) : null);
    setReactionEmoji(reactionView3, reactions.size() >= 3 ? reactions.get(2) : null);

    textCount.setText(
        Utils.getCount(
            Stream.ofNullable(reactions)
                .map(Reaction::getCount)
                .collect(Collectors.summingInt(Integer::intValue)),
            false
        )
    );
  }

  private void setReactionEmoji(AppCompatImageView reactionView, @Nullable Reaction reaction) {
    if (reaction != null && reaction.getEmojiName() != null) {
      reactionView.setVisibility(View.VISIBLE);

      Glide.with(context)
          .load(String.format(Const.EMOJI_BASE_URL, AssetUtils.urlEncode(reaction.getEmojiName())))
          .centerCrop()
          .dontAnimate()
          .diskCacheStrategy(DiskCacheStrategy.SOURCE)
          .into(reactionView);
    } else {
      reactionView.setVisibility(View.GONE);
    }
  }

  @Override
  public void resetView() {
  }

  @Override
  public void clear() {
  }
}
