package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.*;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.ActionButtonView;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.ChEndFlowLayout;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;

import java.util.List;

public abstract class AbsHostMessageHolder extends BaseMessageHolder {

  private AvatarLayout avatarHostMessage;
  private TextView textHostName;
  private ChEndFlowLayout layoutActionButtons;

  AbsHostMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
    super(itemView, listener);

    avatarHostMessage = itemView.findViewById(R.id.ch_avatarMessageHolder);
    textHostName = itemView.findViewById(R.id.ch_textMessageHolderName);

    layoutActionButtons = itemView.findViewById(R.id.chLayoutMessageContentActionButtons);
  }

  public final void bind(@Nullable PersonEntity person, Long createdAt, boolean showDate, boolean isHead, boolean isTail) {
    super.bind(createdAt, showDate, isHead, isTail);

    ProfileEntity profile = Optional.ofNullable(person)
        .map(p -> ProfileSelector.getProfile(p.getPersonType(), p.getPersonId()))
        .orElse(null);

    if (isHead && profile != null) {
      if (avatarHostMessage != null) {
        avatarHostMessage.setVisibility(View.VISIBLE);
        avatarHostMessage.set(profile);
      }
      if (textHostName != null) {
        textHostName.setText(Optional.ofNullable(profile).map(ProfileEntity::getName).orElse(null));
      }
    } else {
      if (avatarHostMessage != null) {
        avatarHostMessage.setVisibility(View.INVISIBLE);
      }
      if (textHostName != null) {
        textHostName.setText(null);
      }
    }
  }

  @Nullable
  @Override
  protected Marketing getMarketing() {
    return null;
  }

  protected void setActionButtons(@Nullable String actionType, @Nullable List<ActionButton> buttons) {
    layoutActionButtons.removeAllViews();

    if (actionType != null && ListUtils.hasItems(buttons) && layoutActionButtons != null) {
      layoutActionButtons.setVisibility(View.VISIBLE);

      for (ActionButton actionButton : buttons) {
        layoutActionButtons.addView(new ActionButtonView(context, actionType, actionButton, this));
      }
    } else if (layoutActionButtons != null) {
      layoutActionButtons.setVisibility(View.GONE);
    }
  }

  protected static View getItemView(ViewGroup parent) {
    return LayoutInflater.from(parent.getContext()).inflate(R.layout.ch_holder_host_message, parent, false);
  }

  @Override
  protected void onRecycled() {
    super.onRecycled();

    if (avatarHostMessage != null) {
      Glide.clear(avatarHostMessage);
    }
  }
}
