package com.zoyi.channel.plugin.android.activity.settings.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings.enumerate.OptionType;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.com.annimon.stream.Optional;

public class SettingsOptionView extends LinearLayout implements View.OnClickListener {

  private TextView textLabel;
  private TextView textValue;
  private TextView textPlaceholder;

  @Nullable
  private SettingsOptionInteractionListener settingsOptionInteractionListener;

  private OptionType optionType = OptionType.NONE;

  @Nullable
  private String key;

  @Nullable
  private Object value;

  public SettingsOptionView(Context context) {
    super(context);
    init(context);
  }

  public SettingsOptionView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public SettingsOptionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_settings_option, this, true);

    view.setOnClickListener(this);

    textLabel = view.findViewById(R.id.ch_textSettingsOptionLabel);
    textValue = view.findViewById(R.id.ch_textSettingsOptionValue);
    textPlaceholder = view.findViewById(R.id.ch_textSettingsOptionPlaceholder);
  }

  public void setSettingsOptionInteractionListener(
      @Nullable SettingsOptionInteractionListener settingsOptionInteractionListener
  ) {
    this.settingsOptionInteractionListener = settingsOptionInteractionListener;
  }

  public void setData(OptionType optionType, String text) {
    this.optionType = optionType;
    this.key = null;
    this.value = null;

    this.textLabel.setVisibility(View.GONE);
    this.textValue.setVisibility(View.VISIBLE);
    this.textValue.setText(text);
    this.textPlaceholder.setVisibility(View.GONE);
  }

  public void setData(ProfileBotSchema schema, User user) {
    this.optionType = OptionType.PROFILE;
    this.key = schema.getKey();
    this.value = user.getProfileValue(schema.getKey());

    this.textLabel.setVisibility(View.VISIBLE);
    this.textLabel.setText(Optional.ofNullable(schema).map(ProfileBotSchema::getNameI18n).map(I18n::get).orElse(null));

    if (value != null) {
      this.textValue.setVisibility(View.VISIBLE);
      this.textPlaceholder.setVisibility(View.GONE);

      this.textValue.setText(FormatUtils.formatUserProfile(key, schema.getType(), value));
    } else {
      this.textValue.setVisibility(View.GONE);
      this.textPlaceholder.setVisibility(View.VISIBLE);
    }
  }

  @Override
  public void onClick(View v) {
    if (settingsOptionInteractionListener != null) {
      settingsOptionInteractionListener.onOptionClick(optionType, key, value);
    }
  }
}
