/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.chat;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnNewMessageAlertClickListener;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class NewMessageAlertView
extends FrameLayout {
    private View root;
    private AvatarLayout avatarPreview;
    @Nullable
    private OnNewMessageAlertClickListener listener;

    public NewMessageAlertView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public NewMessageAlertView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public NewMessageAlertView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_new_message_alert, (ViewGroup)this);
        this.root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewMessageAlertView.this.hide();
                if (NewMessageAlertView.this.listener != null) {
                    NewMessageAlertView.this.listener.onNewMessageAlertClick();
                }
            }
        });
        this.avatarPreview = (AvatarLayout)this.root.findViewById(R.id.ch_layoutAvatarPreview);
    }

    public void setListener(OnNewMessageAlertClickListener listener) {
        this.listener = listener;
    }

    public void show(@Nullable ProfileEntity profileEntity) {
        this.avatarPreview.set(profileEntity);
        this.root.setVisibility(0);
    }

    public void hide() {
        this.root.setVisibility(8);
    }
}

