package com.zoyi.channel.plugin.android.view.youtube.player.views;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

/**
 * A FrameLayout with an aspect ration of 16:9, when the height is set to wrap_content.
 */
class SixteenByNineFrameLayout extends FrameLayout {

  public SixteenByNineFrameLayout(Context context) {
    this(context, null);
  }

  public SixteenByNineFrameLayout(Context context, @Nullable AttributeSet attrs) {
    this(context, attrs, 0);
  }

  public SixteenByNineFrameLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    if (getLayoutParams().height == ViewGroup.LayoutParams.WRAP_CONTENT) {
      int sixteenNineHeight = View.MeasureSpec
          .makeMeasureSpec(View.MeasureSpec.getSize(widthMeasureSpec) * 9 / 16, View.MeasureSpec.EXACTLY);
      super.onMeasure(widthMeasureSpec, sixteenNineHeight);
    } else {
      super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
  }
}
