package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;

public class ChatStartButton extends CardView implements View.OnClickListener {

  public ChatStartButton(@NonNull Context context) {
    super(context);
    init(context);
  }

  public ChatStartButton(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChatStartButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private View background;
  private ImageView iconButton;
  private TextView textButton;

  @Nullable
  private OnClickListener listener;

  private int backColor = Color.BLACK;
  private int textColor = Color.WHITE;

  @Nullable
  private Binder styleBinder;

  @Nullable
  private Binder activeBinder;

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_chat_start, this, true);

    background = view.findViewById(R.id.ch_layoutChatStartButton);
    iconButton = view.findViewById(R.id.ch_imageChatStartButton);
    textButton = view.findViewById(R.id.ch_textChatStartButton);

    view.findViewById(R.id.ch_cardChatStartButton).setOnClickListener(this);

    if (android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
      getBackground().setAlpha(0);
    } else {
      setBackgroundColor(ContextCompat.getColor(context, android.R.color.transparent));
    }
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    styleBinder = PluginSelector.bindPlugin(plugin -> {
      if (plugin != null) {
        if (plugin.getTextColor() == Color.WHITE) {
          setTheme(plugin.getBackgroundColor(), Color.WHITE);
        } else {
          setTheme(plugin.getBackgroundColor(), ResUtils.getColor(R.color.ch_grey900));
        }
      }
    });

    activeBinder = ChannelSelector.bindDisableStartChat(disabled -> this.setEnabled(!disabled));
  }

  @Override
  protected void onDetachedFromWindow() {
    if (styleBinder != null) {
      styleBinder.unbind();
    }
    if (activeBinder != null) {
      activeBinder.unbind();
    }

    super.onDetachedFromWindow();
  }

  @Override
  public void setOnClickListener(@Nullable OnClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void onClick(View v) {
    if (listener != null && isEnabled()) {
      listener.onClick(v);
    }
  }

  private void setTheme(int backColor, int textColor) {
    this.backColor = backColor;
    this.textColor = textColor;

    applyTheme();
  }

  @Override
  public void setEnabled(boolean enabled) {
    super.setEnabled(enabled);

    applyTheme();
  }

  private void applyTheme() {
    if (isEnabled()) {
      background.setBackgroundColor(backColor);
      iconButton.setColorFilter(textColor);
      textButton.setTextColor(textColor);
      setCardElevation(Utils.dpToPx(4));
    } else {
      background.setBackgroundColor(ResUtils.getColor(R.color.ch_grey200));
      iconButton.setColorFilter(ResUtils.getColor(R.color.ch_grey500));
      textButton.setTextColor(ResUtils.getColor(R.color.ch_grey500));
      setCardElevation(0);
    }
  }
}
