package com.zoyi.channel.plugin.android.network;

import android.content.Context;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.okhttp3.OkHttpClient;
import com.zoyi.okhttp3.logging.HttpLoggingInterceptor;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.zoyi.retrofit2.converter.gson.GsonConverterFactory;

import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2016. 1. 20..
 */
public class ServiceFactory {

  public static String getRestEndPoint() {
    Context context = ChannelIO.getAppContext();

    if (context != null) {
      return context.getString(R.string.api_endpoint);
    }
    return "https://api.channel.io/";
  }

  static String getFileEndPoint() {
    Context context = ChannelIO.getAppContext();

    if (context != null) {
      return context.getString(R.string.file_api_endpoint);
    }
    return "https://media.channel.io/";
  }

  public static ChannelApi create() {
    HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor()
        .setLevel(
            !BuildConfig.IS_PRODUCTION_DEPLOYMENT
                || BuildConfig.DEBUG
                || BuildConfig.FLAVOR.equals("exp")
                ? HttpLoggingInterceptor.Level.BODY
                : HttpLoggingInterceptor.Level.NONE
        );

    OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder()
        .addInterceptor(new LanguageInterceptor())
        .addInterceptor(new RetrofitInterceptor())
        .addInterceptor(new UserAgentInterceptor())
        .addInterceptor(new ServerTimeInterceptor())
        .addInterceptor(loggingInterceptor);

    OkHttpClient client = clientBuilder.build();

    return new Retrofit.Builder()
        .baseUrl(getRestEndPoint())
        .client(client)
        .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(ParseUtils.getCustomGson()))
        .build()
        .create(ChannelApi.class);
  }

  public static SimpleChannelApi simpleCreate() {
    HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor()
        .setLevel(
            !BuildConfig.IS_PRODUCTION_DEPLOYMENT
                || BuildConfig.DEBUG
                || BuildConfig.FLAVOR.equals("exp")
                ? HttpLoggingInterceptor.Level.BODY
                : HttpLoggingInterceptor.Level.NONE);

    OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder()
        .addInterceptor(new LanguageInterceptor())
        .addInterceptor(new UserAgentInterceptor())
        .addInterceptor(new ServerTimeInterceptor())
        .addInterceptor(loggingInterceptor);

    OkHttpClient client = clientBuilder.build();

    return new Retrofit.Builder()
        .baseUrl(getRestEndPoint())
        .client(client)
        .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(ParseUtils.getCustomGson()))
        .build()
        .create(SimpleChannelApi.class);
  }

  public static MediaChannelApi mediaCreate() {
    HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor()
        .setLevel(!BuildConfig.IS_PRODUCTION_DEPLOYMENT || BuildConfig.DEBUG || BuildConfig.FLAVOR.equals("exp")
            ? HttpLoggingInterceptor.Level.HEADERS
            : HttpLoggingInterceptor.Level.NONE
        );

    OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder()
        .addInterceptor(new LanguageInterceptor())
        .addInterceptor(new ServerTimeInterceptor())
        .addInterceptor(loggingInterceptor);

    OkHttpClient client = clientBuilder
        .connectTimeout(5, TimeUnit.MINUTES)
        .readTimeout(5, TimeUnit.MINUTES)
        .writeTimeout(10, TimeUnit.MINUTES)
        .build();

    return new Retrofit.Builder()
        .baseUrl(getFileEndPoint())
        .client(client)
        .addCallAdapterFactory(RxJavaCallAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(ParseUtils.getCustomGson()))
        .build()
        .create(MediaChannelApi.class);
  }
}
