package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.selector.*;
import com.zoyi.channel.plugin.android.store.binder.Binder;

public class ChannelActionHandler {

  @Nullable
  private com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener;

  @Nullable
  private ChannelPluginListener legacyListener;

  @Nullable
  private Binder socketBinder;

  @Nullable
  private Binder countHandler;

  @Nullable
  private Binder popupHandler;

  @Nullable
  private Binder legacyInAppPushHandler;

  @Nullable
  private Binder messengerVisibilityBinder;

  public void handle() {
    messengerVisibilityBinder = GlobalSelector.bindMessengerVisibility(visible -> {
      if (listener != null) {
        if (visible) {
          listener.onShowMessenger();
        } else {
          listener.onHideMessenger();
        }
      }

      if (legacyListener != null) {
        if (visible) {
          legacyListener.willShowMessenger();
        } else {
          legacyListener.willHideMessenger();
        }
      }
    });

    socketBinder = SocketSelector.bindSocket(socketStatus -> {
      if (socketStatus == SocketStatus.READY) {
        UserAction.touch();
      }
    });

    countHandler = UserSelector.bindUserAlertCount(count -> {
      if (listener != null && count != null) {
        listener.onBadgeChanged(count);
      }

      if (legacyListener != null && count != null) {
        legacyListener.onChangeBadge(count);
      }
    });

    popupHandler = GlobalSelector.bindPopup(popupData -> {
      if (listener != null && popupData != null) {
        listener.onPopupDataReceived(popupData);
      }
    });

    legacyInAppPushHandler = GlobalSelector.bindLegacyInAppPush(pushEvent -> {
      if (legacyListener != null && pushEvent != null) {
        legacyListener.onReceivePush(pushEvent);
      }
    });
  }

  public void unHandle() {
    if (messengerVisibilityBinder != null) {
      messengerVisibilityBinder.unbind();
      messengerVisibilityBinder = null;
    }

    if (socketBinder != null) {
      socketBinder.unbind();
      socketBinder = null;
    }

    if (countHandler != null) {
      countHandler.unbind();
      countHandler = null;
    }

    if (legacyInAppPushHandler != null) {
      legacyInAppPushHandler.unbind();
      legacyInAppPushHandler = null;
    }

    if (popupHandler != null) {
      popupHandler.unbind();
      popupHandler = null;
    }
  }

  @Nullable
  public com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener getListener() {
    return listener;
  }

  public void setListener(@Nullable com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener) {
    this.listener = listener;
  }

  @Nullable
  public ChannelPluginListener getLegacyListener() {
    return legacyListener;
  }

  public void setLegacyListener(@Nullable ChannelPluginListener listener) {
    this.legacyListener = listener;
  }

  public void clearListener() {
    this.listener = null;
    this.legacyListener = null;
  }
}
