/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class FileAttachmentView
extends ChBorderLayout {
    private Context context;
    private ImageView iconFileAttachment;
    private TextView textFileAttachmentName;
    private TextView textFileAttachmentInfo;
    @Nullable
    private File attachment;
    @Nullable
    private OnAttachmentContentActionListener listener;
    @Nullable
    private View.OnLongClickListener longClickListener;

    public FileAttachmentView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public FileAttachmentView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FileAttachmentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_holder_item_file_attachment, (ViewGroup)this);
        this.iconFileAttachment = (ImageView)this.findViewById(R.id.ch_iconFileAttachment);
        this.textFileAttachmentName = (TextView)this.findViewById(R.id.ch_textFileAttachmentName);
        this.textFileAttachmentInfo = (TextView)this.findViewById(R.id.ch_textFileAttachmentInfo);
        this.setOnClickListener(v -> {
            if (this.listener != null && this.attachment != null) {
                this.listener.onAttachmentClick(this.attachment);
            }
        });
        this.setOnLongClickListener(v -> {
            if (this.longClickListener != null) {
                return this.longClickListener.onLongClick(v);
            }
            return false;
        });
    }

    public void setAttachment(File attachment, @Nullable OnAttachmentContentActionListener listener) {
        this.attachment = attachment;
        this.listener = listener;
        Glide.with((Context)this.context).load(AssetUtils.getIconUrl(this.context, FilenameUtils.getExtension(attachment.getName()))).centerCrop().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(this.iconFileAttachment);
        this.textFileAttachmentName.setText((CharSequence)attachment.getName());
        String contentSize = FormatUtils.formatFileSize(attachment.getSize());
        String extension = (String)Optional.ofNullable((Object)attachment.getExtension()).map(String::toLowerCase).map(e -> String.format(" \u2022 %s", e)).orElse((Object)"");
        this.textFileAttachmentInfo.setText((CharSequence)String.format("%s%s", contentSize, extension));
    }

    public void clear() {
        Glide.clear((View)this.iconFileAttachment);
    }
}

