package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

/**
 * Created by mika on 2016. 2. 2..
 */
public class AvatarLayout extends FrameLayout {

  private ChBorderLayout rootLayout;
  private ImageView image;

  private Float borderRadius = 0f;

  private boolean clearOnDetach = true;

  public AvatarLayout(Context context) {
    super(context);
    init(context, null);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
    super(context, attrs, defStyleAttr, defStyleRes);
    init(context, attrs);
  }

  @Initializer
  protected void init(Context context, @Nullable AttributeSet attrs) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_avatar, this);

    rootLayout = root.findViewById(R.id.ch_rootAvatarLayout);
    image = root.findViewById(R.id.ch_imageAvatar);

    if (attrs != null) {

      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.AvatarLayout,
          0,
          0);

      try {
        borderRadius = typedArray.getDimension(R.styleable.AvatarLayout_ch_avatar_border_radius, borderRadius);
        clearOnDetach = typedArray.getBoolean(R.styleable.AvatarLayout_ch_clear_on_detach, clearOnDetach);
      } finally {
        typedArray.recycle();
      }
    }

    rootLayout.setBorderRadius(borderRadius);
  }

  public void set(@Nullable ProfileEntity entity) {
    if (entity == null || entity.getAvatarUrl() == null) {

      image.setImageResource(R.drawable.ch_default_avatar);
    } else {

      if (getContext() instanceof Activity) {
        Activity activity = (Activity) getContext();

        if (!activity.isFinishing()) {
          Glide.with(activity)
              .load(entity.getAvatarUrl())
              .centerCrop()
              .dontAnimate()
              .diskCacheStrategy(DiskCacheStrategy.RESULT)
              .into(image);
        }
      }
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    if (clearOnDetach) {
      Glide.clear(image);
    }
    super.onDetachedFromWindow();
  }
}
