package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.webkit.MimeTypeMap;

import com.zoyi.channel.plugin.android.util.io.FilenameUtils;

import java.io.File;
import java.util.Random;

public class FileUtils {

  public static boolean createDirectory(File dir) {
    if (!dir.exists()) {
      return dir.mkdirs();
    }
    return true;
  }

  public static boolean deleteFile(File file) {
    return file.exists() && file.delete();
  }

  public static void openFile(Activity activity, Uri uri) {
    Intent intent = new Intent(Intent.ACTION_VIEW)
        .setDataAndType(uri, MimeTypeMap.getSingleton().getMimeTypeFromExtension(FilenameUtils.getExtension(uri.getPath())))
        .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_GRANT_READ_URI_PERMISSION);

    activity.startActivity(intent);
  }
}
