package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;

import java.util.ArrayList;
import java.util.List;

public class Reaction {

  @Nullable
  private String emojiName;
  @Nullable
  private List<String> personKeys;

  @Nullable
  public String getEmojiName() {
    return emojiName;
  }

  @Nullable
  public List<String> getPersonKeys() {
    return personKeys;
  }

  public int getCount() {
    if (personKeys != null) {
      return personKeys.size();
    }
    return 0;
  }

  @NonNull
  public List<String> getManagerIds() {
    List<String> managerIds = new ArrayList<>();

    if (personKeys != null) {
      for (String personKey : personKeys) {
        if (personKey.startsWith(MANAGER_PREFIX) && personKey.length() > MANAGER_PREFIX.length()) {
          managerIds.add(personKey.substring(MANAGER_PREFIX.length()));
        }
      }
    }
    return managerIds;
  }

  private static String MANAGER_PREFIX = Const.MANAGER + "-";
}
